package com.kms.katalon.core.webui.common.future;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

import com.kms.katalon.core.webui.exception.AbortException;
import com.kms.katalon.logging.LogUtil;

public class AbortSignal {
    private final AtomicBoolean aborted = new AtomicBoolean(false);

    private String reason;

    private final CopyOnWriteArrayList<Consumer<AbortSignal>> listeners = new CopyOnWriteArrayList<>();

    public void abort(String reason) {
        if (aborted.compareAndSet(false, true)) {
            this.reason = reason;
            // Notify all listeners
            for (Consumer<AbortSignal> listener : listeners) {
                try {
                    listener.accept(this);
                } catch (Exception e) {
                    // Log error but continue notifying other listeners
                    LogUtil.logError(e, "Error in abort listener: " + e.getMessage());
                }
            }
            listeners.clear();
        }
    }

    public boolean isAborted() {
        return aborted.get();
    }

    public String getReason() {
        return reason;
    }

    public void throwIfAborted() {
        if (isAborted()) {
            throw new AbortException(reason);
        }
    }

    public void addListener(Consumer<AbortSignal> listener) {
        if (listener != null && !listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void removeListener(Consumer<AbortSignal> listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }
}
