package com.kms.katalon.core.webui.driver;

import java.util.Optional;

import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverListener;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.keyword.internal.KeywordExecutor;
import com.kms.katalon.core.webui.common.internal.SmartWait;
import com.kms.katalon.selenium.driver.IDelayableDriver;

/**
 * Event listener that triggers smart wait functionality on
 * <ul>
 * <li>before finding element</li>
 * </ul>
 *
 */
public class KatalonSmartEventListener implements WebDriverListener {

    private final WebDriver driver;

    public KatalonSmartEventListener(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public void beforeClick(WebElement element) {
        doDelay(driver);
    }

    @Override
    public void beforeSendKeys(WebElement element, CharSequence[] keysToSend) {
        doDelay(driver);
    }

    @Override
    public void beforeBack(WebDriver.Navigation navigation) {
        doDelay(driver);
    }

    @Override
    public void beforeForward(WebDriver.Navigation navigation) {
        doDelay(driver);
    }

    @Override
    public void beforeRefresh(WebDriver.Navigation navigation) {
        doDelay(driver);
    }

    @Override
    public void beforeTo(WebDriver.Navigation navigation, String url) {
        doDelay(driver);
    }

    @Override
    public void beforeAccept(Alert alert) {
        doDelay(driver);
    }

    @Override
    public void beforeDismiss(Alert alert) {
        doDelay(driver);
    }

    @Override
    public void beforeFindElement(WebDriver driver, By locator) {
        doSmartWait(driver, KeywordExecutor.getRemainingKeywordTimeoutInMillis());
    }

    @Override
    public void beforeFindElements(WebDriver driver, By locator) {
        doSmartWait(driver, KeywordExecutor.getRemainingKeywordTimeoutInMillis());
    }

    @Override
    public void beforeFindElement(WebElement element, By locator) {
        doSmartWait(driver, KeywordExecutor.getRemainingKeywordTimeoutInMillis());
    }

    @Override
    public void beforeFindElements(WebElement element, By locator) {
        doSmartWait(driver, KeywordExecutor.getRemainingKeywordTimeoutInMillis());
    }

    private void doDelay(WebDriver driver) {
        if (driver instanceof IDelayableDriver delayableDriver) {
            delayableDriver.delay();
        }
    }

    private void doSmartWait(WebDriver driver, long remainingTimeoutInMillis) {
        boolean localSmartWaitEnabled = (boolean) Optional
                .ofNullable(RunConfiguration.getExecutionProperties().get(RunConfiguration.LOCAL_SMART_WAIT_MODE))
                .orElse(true);

        boolean globalSmartWaitEnabled = (boolean) Optional
                .ofNullable(RunConfiguration.getExecutionProperties().get(RunConfiguration.GLOBAL_SMART_WAIT_MODE))
                .orElse(false);

        if (globalSmartWaitEnabled && localSmartWaitEnabled) {
            SmartWait.doSmartWait(driver, remainingTimeoutInMillis);
        }
    }
}
