package com.kms.katalon.core.webui.driver.chrome;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class ChromeHeadlessDriverBuilder extends ChromeDriverBuilder {

    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        var options = super.createOptions(capabilities);

        if (options instanceof ChromeOptions chromeOptions) {
            chromeOptions.addArguments("--headless=new", "disable-gpu");
        }

        return options;
    }
}
