package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement
import org.openqa.selenium.support.ui.Select

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "deselectOptionByValue")
public class DeselectOptionByValueKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        String value = (String) params[1]
        boolean isRegex = (boolean) params[2]
        FailureHandling flowControl = (FailureHandling)(params.length > 3 && params[3] instanceof FailureHandling ? params[3] : RunConfiguration.getDefaultFailureHandling())
        deselectOptionByValue(to,value,isRegex,flowControl)
    }

    @CompileStatic
    public void deselectOptionByValue(TestObject to, String value, boolean isRegex, FailureHandling flowControl)
    throws StepFailedException {
        String regularExpressionLog = ((isRegex) ? " using regular expression" : "")
        WebDriver driver = DriverFactory.getWebDriver()

        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()

        WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_VAL_PARAM)
                if (value == null) {
                    throw new IllegalArgumentException(StringConstants.KW_EXC_VAL_IS_NULL)
                }
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(to)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(to)
                logger.logDebug("Checking if element is interactable: " + to.getObjectId());
                if (webElement != null && driver instanceof JavascriptExecutor) {
                    waitElementInteractable((JavascriptExecutor) driver, webElement, timeoutInMillis, (RetryContext) retryContext);
                }
                boolean isMatched = WebUiCommonHelper.selectOrDeselectOptionsByValue(new Select(webElement), value, isRegex, false, to, regularExpressionLog)
                if (isMatched) {
                    logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OPTS_W_VAL_ARE_DESELECTED_ON_OBJ, value, to.getObjectId(), regularExpressionLog))
                } else {
                    KeywordMain.stepFailed(CoreWebuiMessageConstants.KW_MSG_NO_OPTION_MATCHED, flowControl);
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null && value != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_DESELECT_OPT_BY_VAL_OF_OBJ, value, to.getObjectId(), regularExpressionLog) : MessageFormat.format(StringConstants.KW_MSG_CANNOT_DESELECT_OPT_BY_VAL, regularExpressionLog))
    }
}
