package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.ElementNotInteractableException
import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement
import org.openqa.selenium.support.ui.Select

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "selectOptionByValue")
public class SelectOptionByValueKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        String value = (String) params[1]
        boolean isRegex = (boolean) params[2]
        FailureHandling flowControl = (FailureHandling)(params.length > 3 && params[3] instanceof FailureHandling ? params[3] : RunConfiguration.getDefaultFailureHandling())
        selectOptionByValue(to,value,isRegex,flowControl)
    }

    @CompileStatic
    public void selectOptionByValue(TestObject to, String value, boolean isRegex, FailureHandling flowControl) throws StepFailedException {
        String regularExpressionLog = ((isRegex) ? " using regular expression" : "")
        WebDriver driver = DriverFactory.getWebDriver()

        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()
        
        WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_VAL_PARAM)
                if (value == null) {
                    throw new IllegalArgumentException(StringConstants.KW_EXC_VAL_IS_NULL)
                }
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(driver, to, timeoutInMillis)
                logger.logDebug("Checking if element is interactable: " + to.getObjectId());
                if (webElement != null && driver instanceof JavascriptExecutor) {
                    waitElementInteractable((JavascriptExecutor) driver, webElement, timeoutInMillis, (RetryContext) retryContext);
                }
                boolean isMatched = selectOrDeselectOptionsByValue(driver, webElement, value, isRegex, true, to, regularExpressionLog)
                if (isMatched) {
                    logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SELECTED_ALL_OPT_W_VAL_X_IN_OBJ_Y, value, to.getObjectId(), regularExpressionLog))
                } else {
                    KeywordMain.stepFailed(CoreWebuiMessageConstants.KW_MSG_NO_OPTION_MATCHED, flowControl);
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null && value != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_SELECT_OPT_BY_VAL_OF_OBJ, value, to.getObjectId(), regularExpressionLog) : MessageFormat.format(StringConstants.KW_MSG_CANNOT_SEL_OPT_BY_VAL, regularExpressionLog))
    }

    private boolean selectOrDeselectOptionsByValue(WebDriver driver, WebElement webElement, String value, boolean isRegex, boolean isSelect, TestObject to, String regularExpressionLog) {
        try {
            return WebUiCommonHelper.selectOrDeselectOptionsByValue(new Select(webElement), value, isRegex, true, to, regularExpressionLog)
        } catch (ElementNotInteractableException e) {
            // The web element is invisible
            // Try scroll to web element by Java script and do the action again
            JavascriptExecutor js = (JavascriptExecutor) driver;
            js.executeScript("arguments[0].scrollIntoView();", webElement);
            return WebUiCommonHelper.selectOrDeselectOptionsByValue(new Select(webElement), value, isRegex, true, to, regularExpressionLog)
        }
    }
}
