package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.exception.WebElementNotFoundException
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "verifyElementVisible")
public class VerifyElementVisibleKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        return verifyElementVisible(to,flowControl)
    }

    @CompileStatic
    public boolean verifyElementVisible(TestObject to, FailureHandling flowControl) throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver()
        
        int timeoutInSeconds = RunConfiguration.getElementTimeoutForWeb()
        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()
        
        return WebUIKeywordMain.runKeywordUntilTimeout({
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to, timeoutInSeconds)
                try {
                    WebElement foundElement = findWebElement(driver, to, timeoutInMillis)
                    if (foundElement != null && foundElement.isDisplayed()) {
                        logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_X_IS_VISIBLE, to.getObjectId()))
                        return true
                    } else {
                        WebUIKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_X_IS_NOT_VISIBLE, to.getObjectId()),
                                flowControl, null, true)
                        return false
                    }
                    return true
                } catch (WebElementNotFoundException e) {
                    WebUIKeywordMain.stepFailed(e.getMessage(), flowControl, null, true)
                    return false
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent()
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_VERIFY_OBJ_X_TO_BE_VISIBLE, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_VERIFY_OBJ_TO_BE_VISIBLE)
    }
}
