package com.kms.katalon.core.webui.keyword.internal;

import java.util.concurrent.TimeUnit

import org.openqa.selenium.TimeoutException

import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.helper.KeywordHelper
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.model.TakeScreenshotOption
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.helper.screenshot.WebUIScreenCaptor
import com.kms.katalon.core.webui.model.SeleniumActionRetryController
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryableAction

import groovy.transform.CompileStatic

public class WebUIKeywordMain {

    private static final String TIMED_OUT_WAITING_FOR_PAGE_LOAD = "Timed out waiting for page load."

    @CompileStatic
    public static runKeyword(Closure closure, FailureHandling flowControl, boolean takeScreenShot, String errorMessage) {
        try {
            return closure.call();
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShot);
                return;
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShot);
        }
    }

    @CompileStatic
    public static runKeyword(Closure closure, FailureHandling flowControl, TakeScreenshotOption takeScreenShotOption, String errorMessage) {
        boolean takeScreenShotFailedSteps = takeScreenShotOption == TakeScreenshotOption.FAILED_STEPS;
        try {
            Object result = closure.call();
//            takeScreenShotForEveryStep(takeScreenShotOption);
            return result;
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShotFailedSteps);
                return;
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShotFailedSteps);
        }
    }

    @CompileStatic
    public static runKeyword(Closure closure, Closure failedClosure, FailureHandling flowControl, boolean takeScreenShot, String errorMessage) {
        try {
            return closure.call();
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShot);
                if (failedClosure != null) {
                    return failedClosure
                }
                return
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShot);
        }
    }

    @CompileStatic
    public static runKeyword(Closure closure, Closure failedClosure, FailureHandling flowControl, TakeScreenshotOption takeScreenShotOption, String errorMessage) {
        boolean takeScreenShotFailedSteps = takeScreenShotOption == TakeScreenshotOption.FAILED_STEPS;
        try {
            Object result = closure.call();
//            takeScreenShotForEveryStep(takeScreenShotOption);
            return result;
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShotFailedSteps);
                if (failedClosure != null) {
                    return failedClosure
                }
                return
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShotFailedSteps);
        }
    }

    // Add this for keywords that need to return int, as Groovy cannot automatically convert null to int
    @CompileStatic
    public static int runKeywordAndReturnInt(Closure closure, FailureHandling flowControl, boolean takeScreenShot, String errorMessage) {
        try {
            return (int) closure.call();
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShot);
                return -1;
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShot);
        }
        return -1;
    }

    @CompileStatic
    public static int runKeywordAndReturnInt(Closure closure, FailureHandling flowControl, TakeScreenshotOption takeScreenShotOption, String errorMessage) {
        boolean takeScreenShotFailedSteps = takeScreenShotOption == TakeScreenshotOption.FAILED_STEPS;
        try {
            int result = (int) closure.call();
//            takeScreenShotForEveryStep(takeScreenShotOption);
            return result;
        } catch (Throwable e) {
            if (isPageLoadTimeoutException(e) && DriverFactory.isEnablePageLoadTimeout() && DriverFactory.isIgnorePageLoadTimeoutException()) {
                stepFailed(errorMessage, FailureHandling.OPTIONAL, e, takeScreenShotFailedSteps);
                return -1;
            }
            stepFailed(errorMessage, flowControl, e, takeScreenShotFailedSteps);
        }
        return -1;
    }

    /**
     * Retries the given action until the timeout is reached.
     * if no timeout is specified, it will use the default timeout
     * 
     * @param closure
     * @param flowControl
     * @param takeScreenshotOption
     * @param errorMessage
     */
    @CompileStatic
    public static runKeywordUntilTimeout(RetryableAction action, FailureHandling flowControl, TakeScreenshotOption takeScreenshotOption, String errorMessage) {
        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()

        return runKeyword({
            SeleniumActionRetryController ctrl = new SeleniumActionRetryController();
            ctrl.performAction(action, 0, {retryContext ->
                return retryContext.getElapsedTime() <= timeoutInMillis;
            });
        }, flowControl, takeScreenshotOption, errorMessage);
    }

    /**
     * Retries the given action until the timeout is reached.
     *
     * @param closure
     * @param flowControl
     * @param takeScreenshotOption
     * @param errorMessage
     * @param timeoutInSeconds
     */
    @CompileStatic
    public static runKeywordUntilTimeout(Closure closure, FailureHandling flowControl, TakeScreenshotOption takeScreenshotOption, String errorMessage, int timeoutInSeconds) {
        return runKeyword({
            SeleniumActionRetryController ctrl = new SeleniumActionRetryController();
            long timeout = timeoutInSeconds * 1000L;
            ctrl.performAction(closure, 0, {retryContext -> 
            return retryContext.getElapsedTime() <= timeout; });
        }, flowControl, takeScreenshotOption, errorMessage);
    }

    @CompileStatic
    public static int runKeywordUntilTimeoutAndReturnInt(Closure closure, FailureHandling flowControl, TakeScreenshotOption takeScreenShotOption, String errorMessage) {
        int timeoutInSeconds = RunConfiguration.getElementTimeoutForWeb()

        return runKeywordAndReturnInt({
            SeleniumActionRetryController ctrl = new SeleniumActionRetryController();
            long timeout = TimeUnit.SECONDS.toMillis(timeoutInSeconds);
            return (int) ctrl.performAction(closure, 0, {retryContext ->
                return retryContext.getElapsedTime() <= timeout;
            });
        }, flowControl, takeScreenShotOption, errorMessage);
    }

    @CompileStatic
    public static stepFailed(String message, FailureHandling flHandling, Throwable t, boolean takeScreenShot)
    throws StepFailedException {
        boolean shouldTakeScreenShot = flHandling == FailureHandling.OPTIONAL ? false : takeScreenShot
        KeywordMain.stepFailed(message, flHandling, new StepFailedException(message, t), new WebUIScreenCaptor().takeScreenshotAndGetAttributes(shouldTakeScreenShot));
    }

    @CompileStatic
    public static stepFailedWithReason(String message, FailureHandling flHandling, String reason, boolean takeScreenShot)
    throws StepFailedException {
        KeywordMain.stepFailed(message, flHandling, new StepFailedException(message + ". Reason: " + reason), new WebUIScreenCaptor().takeScreenshotAndGetAttributes(takeScreenShot));
    }

    @CompileStatic
    private static boolean isPageLoadTimeoutException(Throwable e) {
        return (e instanceof TimeoutException) && (e.getMessage().startsWith(TIMED_OUT_WAITING_FOR_PAGE_LOAD));
    }

    @CompileStatic
    private static void takeScreenShotForEveryStep(TakeScreenshotOption option) {
        if (option == TakeScreenshotOption.ALL_STEPS) {
            new WebUIScreenCaptor().takeScreenshot();
        }
    }
}
