package com.kms.katalon.core.webui.model;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.commons.collections4.CollectionUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

import com.kms.katalon.core.keyword.internal.KeywordExecutor;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;

public class WebUiElementFinderWithTimeout implements SeleniumElementFinder<FindElementWithTimeoutParams> {

    private WebUiElementFinder basicElementFinder = new WebUiElementFinder();

    private KeywordLogger logger = KeywordLogger.getInstance(WebUiElementFinderWithTimeout.class);

    @Override
    public WebElement findElement(FindElementWithTimeoutParams params) throws Exception {
        KeywordExecutor.setCurrentKeywordTimeout(params.getTimeoutInMillis());
        if (params.getTimeoutInMillis() <= 0) {
            return basicFindElement(params);
        }
        return new SeleniumActionRetryController().performAction((retryContext) -> {
                return basicFindElement(params);
        }, 0L, (retryContext) -> retryContext.getElapsedTime() <= params.getTimeoutInMillis());
    }

    @Override
    public List<WebElement> findElements(FindElementWithTimeoutParams params) throws Exception {
        TestObject testObject = params.getTestObject();
        if (params.getTimeoutInMillis() <= 0) {
            return basicFindElements(params);
        }
        return new SeleniumActionRetryController().performAction((retryContext) -> {
            if (retryContext.retryCount == 0) {
                logger.logDebug(MessageFormat.format("Finding web element with id: ''{0}'' located by ''{1}''",
                        testObject.getObjectId(),
                        WebUiCommonHelper.buildLocator(testObject, testObject.getSelectorMethod())));
            }
            return basicFindElements(params);
        }, 0L, (retryContext) -> retryContext.getElapsedTime() <= params.getTimeoutInMillis());
    }

    private WebElement basicFindElement(FindElementWithTimeoutParams params) throws Exception {
        WebElement element = basicElementFinder.findElement((FindElementParams) params);
        if (element == null) {
            throw new NoSuchElementException(
                    "No elements found for TestObject: " + params.getTestObject().getObjectId());
        }
        return element;
    }

    private List<WebElement> basicFindElements(FindElementWithTimeoutParams params) throws Exception {
        List<WebElement> elements = basicElementFinder.findElements((FindElementParams) params);
        if (CollectionUtils.isEmpty(elements)) {
            throw new NoSuchElementException(
                    "No elements found for TestObject: " + params.getTestObject().getObjectId());
        }
        return elements;
    }
}
