package com.kms.katalon.core.windows.keyword.builtin;

import com.kms.katalon.core.annotation.internal.Action;
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.AbstractKeyword;
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel;
import com.kms.katalon.core.logging.KeywordLogger
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.WindowsTestObject
import com.kms.katalon.core.util.internal.PathUtil
import com.kms.katalon.core.windows.constants.StringConstants
import com.kms.katalon.core.windows.driver.WindowsDriverFactory
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper

import io.appium.java_client.windows.WindowsDriver

@Action(value = "takeElementScreenshot")
public class TakeElementScreenshotKeyword extends AbstractKeyword {

    private static final String XML_LOG_ATTACHMENT_PROPERTY = com.kms.katalon.core.constants.StringConstants.XML_LOG_ATTACHMENT_PROPERTY;
    private KeywordLogger logger = KeywordLogger.getInstance(TakeElementScreenshotKeyword.class)

    private int ARG_INDEX_FILENAME = 0;
    private int ARG_INDEX_TEST_OBJECT = 1;
    private int ARG_INDEX_FLOW_CONTROL = 2;

    @Override
    public SupportLevel getSupportLevel(Object... params) {
        return SupportLevel.NOT_SUPPORT;
    }

    @Override
    public Object execute(Object ...params) {
        String screenshotLocation = (String) getParam(params, ARG_INDEX_FILENAME);
        if (screenshotLocation == null) {
            screenshotLocation = defaultFileName();
        }

        String fullPath = new File(screenshotLocation).getAbsolutePath();

        WindowsTestObject testObject = (WindowsTestObject)getParam(params, ARG_INDEX_TEST_OBJECT);
        FailureHandling flowControl = getFailureHandling(params, ARG_INDEX_FLOW_CONTROL);
        takeElementScreenshot(fullPath, testObject, flowControl);
    }

    private String defaultFileName() {
        return logger.getLogFolderPath() + File.separator + System.currentTimeMillis() + ".png"
    }

    private String takeElementScreenshot(String filePath, WindowsTestObject testObject, FailureHandling flowControl) throws StepFailedException {
        return (String) KeywordMain.runKeyword({
            WindowsDriver windowsDriver = WindowsDriverFactory.getWindowsDriver()
            if (windowsDriver == null) {
                KeywordMain.stepFailed("WindowsDriver has not started. Please try Windows.startApplication first.", flowControl)
            }
            WindowsActionHelper.create(WindowsDriverFactory.getWindowsSession()).takeElementScreenshot(filePath, testObject);

            Map<String, String> attributes = new HashMap<>()
            attributes.put(XML_LOG_ATTACHMENT_PROPERTY, PathUtil.getRelativePathForLog(filePath));
            logger.logPassed(StringConstants.KW_LOG_PASSED_SCREENSHOT_IS_TAKEN, attributes)
            return filePath
        }, flowControl)
    }
}
