/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.FirefoxDriverConnector;
import com.kms.katalon.execution.webui.driver.WebDriverUpdateManager;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FirefoxRunConfiguration
extends WebUiRunConfiguration {
    protected String driverPath;

    public FirefoxRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new FirefoxDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    public FirefoxRunConfiguration(String projectDir, WebUiDriverConnector webUiDriverConnector) throws IOException {
        super(projectDir, webUiDriverConnector);
        this.driverPath = WebDriverUpdateManager.getInstance().getGeckoDriverPath();
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof FirefoxDriverConnector)) continue;
            FirefoxDriverConnector driverConnector = (FirefoxDriverConnector)entry.getValue();
            driverConnector.setGeckoDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new FirefoxRunConfiguration(this.projectDir);
    }

    public boolean allowsRecording() {
        return true;
    }
}

