/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.impl.RemoteExecutionSetting;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class RemoteWebRunConfiguration
extends AbstractRunConfiguration {
    protected RemoteWebDriverConnector remoteDriverConnector;
    protected String projectDir;

    public RemoteWebRunConfiguration(String projectDir, RemoteWebDriverConnector webUiDriverConnector) throws IOException {
        this.projectDir = projectDir;
        this.remoteDriverConnector = webUiDriverConnector;
        this.doInitExecutionSetting();
    }

    public RemoteWebDriverConnector getRemoteDriverConnector() {
        return this.remoteDriverConnector;
    }

    public RemoteWebRunConfiguration(String projectDir) throws IOException {
        this(projectDir, new RemoteWebDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        LinkedHashMap<String, IDriverConnector> driverCollector = new LinkedHashMap<String, IDriverConnector>();
        driverCollector.put("Remote", (IDriverConnector)this.remoteDriverConnector);
        return driverCollector;
    }

    protected void initExecutionSetting() {
        this.executionSetting = new RemoteExecutionSetting((IDriverConnector)this.remoteDriverConnector);
        ContextInjectionFactory.inject((Object)this.executionSetting, (IEclipseContext)this.context);
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new RemoteWebRunConfiguration(this.projectDir);
    }

    public String getName() {
        String remoteServerUrl = this.remoteDriverConnector.getRemoteServerUrl();
        if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud(this.remoteDriverConnector.getUserConfigProperties())) {
            return super.getName();
        }
        return super.getName() + " - " + StringUtils.defaultIfEmpty((String)remoteServerUrl, (String)"<empty server URL>");
    }

    public String getReportDriverName() {
        return MessageFormat.format("Remote - {0}", this.getRemoteWebDriverConnectorType().name());
    }

    public IRunConfiguration.Type getType() {
        return IRunConfiguration.Type.REMOTE_WEB;
    }

    public String getRemoteServerUrl() {
        return this.remoteDriverConnector.getRemoteServerUrl();
    }

    public void setRemoteServerUrl(String remoteServerUrl) {
        this.remoteDriverConnector.setRemoteServerUrl(remoteServerUrl);
    }

    public RemoteWebDriverConnector.RemoteWebDriverConnectorType getRemoteWebDriverConnectorType() {
        return this.remoteDriverConnector.getRemoteWebDriverConnectorType();
    }

    public void setRemoteWebDriverConnectorType(RemoteWebDriverConnector.RemoteWebDriverConnectorType remoteWebDriverConnectorType) {
        this.remoteDriverConnector.setRemoteWebDriverConnectorType(remoteWebDriverConnectorType);
    }

    public String getRemoteDomain() {
        String remoteServerUrl = this.remoteDriverConnector.getRemoteServerUrl();
        if (StringUtils.isBlank((String)remoteServerUrl)) {
            return "";
        }
        try {
            URI uri = new URI(remoteServerUrl);
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            LogUtil.logError((String)"Failed to retrieve remote URL");
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Return empty remote URL");
            return "";
        }
    }
}

