/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.handler.CommandCaller;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdaterLauncher;
import com.kms.katalon.composer.update.dialogs.InstallUpdateConfirmationDialog;
import com.kms.katalon.composer.update.dialogs.NewUpdateDialog;
import com.kms.katalon.composer.update.jobs.CheckForUpdatesJob;
import com.kms.katalon.composer.update.jobs.DownloadUpdateJob;
import com.kms.katalon.composer.update.models.VersionInfo;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CheckForUpdatesHandler
implements UpdateComponent {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    @Inject
    private IEventBroker eventBroker;
    private boolean shouldWaitUntilProjectOpended = false;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("PROJECT/OPEN_LATEST", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                CheckForUpdatesHandler.this.shouldWaitUntilProjectOpended = true;
            }
        });
        this.eventBroker.subscribe("PROJECT/RESTORE_SESSION_COMPLETED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                CheckForUpdatesHandler.this.shouldWaitUntilProjectOpended = false;
            }
        });
    }

    @Execute
    public void execute() {
        this.checkForUpdate(false);
    }

    public void checkForUpdate(final boolean silenceMode) {
        final CheckForUpdatesJob job = new CheckForUpdatesJob(silenceMode);
        job.setUser(!silenceMode);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!job.getResult().isOK()) {
                    return;
                }
                CheckForUpdatesJob.CheckForUpdateResult newUpdateResult = job.getUpdateResult();
                while (CheckForUpdatesHandler.this.shouldWaitUntilProjectOpended) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                switch (newUpdateResult.getUpdateResult()) {
                    case NEW_UPDATE_FOUND: {
                        if (silenceMode && newUpdateResult.getLatestVersionInfo().isQuickRelease()) {
                            return;
                        }
                        Executors.newSingleThreadExecutor().submit(() -> {
                            try {
                                TimeUnit.MILLISECONDS.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            UISynchronizeService.syncExec(() -> CheckForUpdatesHandler.this.openNewUpdateDialog(newUpdateResult));
                        });
                        break;
                    }
                    case UP_TO_DATE: {
                        if (silenceMode) break;
                        Executors.newSingleThreadExecutor().submit(() -> {
                            try {
                                TimeUnit.MILLISECONDS.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            UISynchronizeService.syncExec(() -> this.showUpToDateDialog());
                        });
                        break;
                    }
                    case APPLIED_LEGACY_MECHANISM: {
                        Executors.newSingleThreadExecutor().submit(() -> {
                            try {
                                TimeUnit.MILLISECONDS.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (VersionUtil.hasNewVersion()) {
                                UISynchronizeService.syncExec(() -> {
                                    boolean wantDownload = MessageDialog.openConfirm(null, (String)MessageConstants.DIA_UPDATE_NEW_VERSION_TITLE, (String)MessageConstants.DIA_UPDATE_NEW_VERSION_MESSAGE);
                                    if (wantDownload) {
                                        VersionUtil.gotoDownloadPage();
                                    }
                                });
                                return;
                            }
                            if (!silenceMode) {
                                UISynchronizeService.syncExec(() -> this.showUpToDateDialog());
                            }
                        });
                        break;
                    }
                    case VERSION_IS_CONTROLLED: {
                        if (silenceMode) {
                            return;
                        }
                        UISynchronizeService.syncExec(() -> this.showVersionIsControlledDialog());
                        break;
                    }
                }
            }

            private void showUpToDateDialog() {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.INFO, (String)MessageConstants.HAND_MSG_UP_TO_DATE);
            }

            private void showVersionIsControlledDialog() {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.INFO, (String)MessageConstants.HAND_MSG_VERSION_CONTROLLED_BY_ADMIN);
            }
        });
        job.schedule();
    }

    private void openNewUpdateDialog(final CheckForUpdatesJob.CheckForUpdateResult newUpdateResult) {
        NewUpdateDialog newUpdateDialog = new NewUpdateDialog(Display.getCurrent().getActiveShell(), newUpdateResult.getCurrentAppInfo().getVersion(), newUpdateResult.getLatestAppInfo().getVersion(), newUpdateResult.getLatestVersionInfo().getReleaseNotesLink());
        switch (newUpdateDialog.open()) {
            case 1025: {
                DownloadUpdateJob updateJob = new DownloadUpdateJob(newUpdateResult);
                updateJob.setUser(true);
                updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            Thread thread = new Thread(() -> {
                                try {
                                    TimeUnit.MILLISECONDS.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {}
                                UISynchronizeService.syncExec(() -> CheckForUpdatesHandler.this.onNewUpdateAlreadyDialog(newUpdateResult));
                            });
                            thread.start();
                        }
                    }
                });
                updateJob.schedule();
                return;
            }
            case 1027: {
                try {
                    VersionInfo localLatestVersion = this.getUpdateManager().getLocalLatestVersion();
                    localLatestVersion.setLatestVersion(newUpdateResult.getLatestVersionInfo().getLatestVersion());
                    localLatestVersion.setLatestVersionIgnored(true);
                    this.getUpdateManager().saveLocalLatestVersionInfo(localLatestVersion);
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                return;
            }
            case 1026: {
                return;
            }
            case 1: {
                return;
            }
        }
    }

    private void onNewUpdateAlreadyDialog(CheckForUpdatesJob.CheckForUpdateResult newUpdateResult) {
        InstallUpdateConfirmationDialog dialog = new InstallUpdateConfirmationDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0) {
            String latestVersion = newUpdateResult.getLatestVersionInfo().getLatestVersion();
            try {
                Thread t = new Thread(() -> {
                    try {
                        WebDriverCleanerUtil.cleanup();
                        AppiumDriverManager.cleanup();
                        UpdaterLauncher updaterLauncher = new UpdaterLauncher(latestVersion, newUpdateResult.getCurrentAppInfo().getVersion());
                        updaterLauncher.startUpdaterLauncher();
                    }
                    catch (IOException | InterruptedException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                });
                t.setDaemon(true);
                t.start();
                new CommandCaller().call("com.kms.katalon.composer.quit");
            }
            catch (CommandException e) {
                MessageDialog.openError(null, (String)GlobalStringConstants.ERROR, (String)MessageConstants.HAND_MSG_UNABLE_TO_INSTALL_NEW_UPDATE);
                LoggerSingleton.logError((Throwable)e);
            }
            return;
        }
    }

    static /* synthetic */ void access$0(CheckForUpdatesHandler checkForUpdatesHandler, CheckForUpdatesJob.CheckForUpdateResult checkForUpdateResult) {
        checkForUpdatesHandler.openNewUpdateDialog(checkForUpdateResult);
    }
}

