/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.exception.RunInstallationStepException;
import com.kms.katalon.composer.components.impl.installer.InstallationManager;
import com.kms.katalon.composer.components.impl.installer.InstallationStep;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.handlers.DriverDownloadManager;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class UpdateChromeWebdriverHandler {
    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell shell) {
        InstallationManager installationManager = new InstallationManager(shell, StringConstants.MSG_UPDATING_WEB_DRIVER);
        installationManager.getInstallationDialog().setDialogTitle(MessageFormat.format(StringConstants.DIA_TITLE_UPDATE_WEBDRIVER, "Chrome"));
        installationManager.getInstallationDialog().setSuccessfulMessage(StringConstants.MSG_WEB_DRIVER_UPDATED_SUCCESSFULLY);
        InstallationStep installationStep = new InstallationStep(StringConstants.MSG_UPDATING_WEB_DRIVER){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    DriverDownloadManager.downloadDriver(WebUIDriverType.CHROME_DRIVER, this.getLogFile(), this.getErrorLogFile());
                }
                catch (IOException error) {
                    throw new RunInstallationStepException(StringConstants.MSG_FAIL_TO_UPDATE_WEB_DRIVER, (Throwable)error);
                }
            }
        };
        installationManager.appendStep(installationStep);
        Trackings.trackUseAutoUpdateChromeDriver();
        try {
            installationManager.startInstallation();
        }
        catch (InvocationTargetException error) {
            LoggerSingleton.logError((Throwable)error);
            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_FAIL_TO_UPDATE_WEB_DRIVER, (String)error.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)error));
        }
        catch (InterruptedException interruptedException) {
            LoggerSingleton.logInfo((String)StringConstants.MSG_USER_CANCEL_UPDATE);
        }
    }
}

