/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.helpers;

import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.AuthenticationRequest;
import com.kms.katalon.session.core.model.exception.AuthenticationException;
import jakarta.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class SSOController {
    public static final String AuthResponseGrabbedEventName = "AUTHENTICATION_RESPONSE_GRABBED";
    private final String AUTHENTICATION_CLIENT_ID_PARAM = "client_id";
    private final String AUTHENTICATION_REDIRECT_URL_PARAM = "redirect_uri";
    private final String AUTHENTICATION_RESPONSE_TYPE_PARAM = "response_type";
    private final String AUTHENTICATION_SCOPE_PARAM = "scope";
    private final String AUTHENTICATION_PROMPT_PARAM = "prompt";
    private final String AUTHENTICATION_CODE_CHALLENGE_PARAM = "code_challenge";
    private final String AUTHENTICATION_CODE_CHALLENGE_METHOD_PARAM = "code_challenge_method";
    private final String SCOPE = "openid";
    private final String PROMT = "login";
    private final String CLIENT_ID = "katalon-studio";
    private final String RESPONSE_TYPE = "code";
    private String loginRedirectUri = "";
    private String realm = "katalon";
    @Inject
    private IDiscoveryController discoveryController;
    private static SSOController instance;

    public static SSOController getInstance() {
        if (instance == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(SSOController.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (SSOController)ContextInjectionFactory.make(SSOController.class, (IEclipseContext)context);
        }
        return instance;
    }

    public SSOController setRedirectServer(String server) {
        try {
            URIBuilder redirectUri = new URIBuilder(server);
            redirectUri.setPath("/auth");
            this.loginRedirectUri = redirectUri.build().toString();
        }
        catch (URISyntaxException error) {
            LogUtil.logError((Throwable)error);
        }
        return this;
    }

    public AuthenticationRequest buildAuthenticationRequest() throws AuthenticationException {
        String codeChallenge;
        String codeVerifier;
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.setRedirectUri(this.loginRedirectUri);
        try {
            codeVerifier = this.generateCodeVerifier();
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException("Failed to generate code verify!", (Throwable)e);
        }
        authenticationRequest.setCodeVerifier(codeVerifier);
        try {
            codeChallenge = this.generateCodeChallenge(codeVerifier);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AuthenticationException("Failed to generate code challenge!", (Throwable)e);
        }
        try {
            URIBuilder authenticationUriBuilder = new URIBuilder(this.discoveryController.getServerUrl(ServerType.AUTHENTICATION));
            authenticationUriBuilder.setPathSegments(new String[]{"realms", this.realm, "protocol", "openid-connect", "auth"}).addParameter("client_id", "katalon-studio").addParameter("redirect_uri", this.loginRedirectUri).addParameter("response_type", "code").addParameter("scope", "openid").addParameter("prompt", "login").addParameter("code_challenge", codeChallenge).addParameter("code_challenge_method", "S256");
            authenticationRequest.setAuthenticationUrl(authenticationUriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException("Invalid server url!", (Throwable)e);
        }
        return authenticationRequest;
    }

    protected String generateCodeVerifier() throws UnsupportedEncodingException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] codeVerifier = new byte[32];
        secureRandom.nextBytes(codeVerifier);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(codeVerifier);
    }

    protected String generateCodeChallenge(String codeVerifier) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytes = codeVerifier.getBytes("US-ASCII");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes, 0, bytes.length);
        byte[] digest = messageDigest.digest();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

