/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.impl.editors.MarkdownPart;
import com.kms.katalon.composer.components.impl.util.ResourcesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WelcomeOnlineRightPart
extends Composite {
    private boolean shouldSetContent = true;

    public WelcomeOnlineRightPart(Composite parent, String contentLink) throws MalformedURLException, IOException {
        super(parent, 0);
        GridLayout glWrapper = new GridLayout(1, false);
        glWrapper.marginTop = 2;
        glWrapper.marginBottom = 2;
        this.setLayout((Layout)glWrapper);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.init(contentLink);
    }

    private void init(String contentLink) throws MalformedURLException, IOException {
        final String content = StringEscapeUtils.escapeEcmaScript((String)this.getContentFromHTML(contentLink));
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        final Browser browser = new Browser(container, 0);
        browser.setJavascriptEnabled(true);
        String sourceContent = ResourcesUtil.getFileContent(MarkdownPart.class, (String)"resources/template/markdown_template.html");
        browser.setText(sourceContent);
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                if (WelcomeOnlineRightPart.this.shouldSetContent) {
                    WelcomeOnlineRightPart.this.shouldSetContent = false;
                    browser.evaluate("document.getElementById('content').innerHTML = marked('" + content + "');");
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                event.doit = false;
                Program.launch((String)event.location);
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    private String getContentFromHTML(String link) throws MalformedURLException, IOException {
        try (BufferedReader br = null;){
            String inputLine;
            URL url = new URL(link);
            URLConnection conn = url.openConnection();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                sb.append(inputLine).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

