/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.wizard.IWizardPage;
import com.kms.katalon.composer.components.impl.wizard.WizardDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.quickstart.APITestingWizardPage;
import com.kms.katalon.composer.quickstart.AdvancedReportWizardPage;
import com.kms.katalon.composer.quickstart.BDDTestingWizardPage;
import com.kms.katalon.composer.quickstart.DatadrivenTestingWizardPage;
import com.kms.katalon.composer.quickstart.DesktopAppsTestingPage;
import com.kms.katalon.composer.quickstart.MobileTestingWizardPage;
import com.kms.katalon.composer.quickstart.PluginStoreWizardPage;
import com.kms.katalon.composer.quickstart.SDLCIntergrationWizardPage;
import com.kms.katalon.composer.quickstart.WebTestingWizardPage;
import com.kms.katalon.composer.quickstart.WizardTableLabelTest;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.tracking.service.Trackings;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class QuickStartDialog
extends WizardDialog {
    private int lastTreeWidth = 240;
    private Composite stepArea;
    private CTableViewer tableViewer;
    private TableViewerColumn pageViewerColumn;

    public QuickStartDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Composite imageComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1024, 1024, false, false);
        Image imageTitle = ImageConstants.IMG_INTRO_SCREEN_TITLE;
        gridData.widthHint = imageTitle.getBounds().width;
        gridData.heightHint = imageTitle.getBounds().height;
        imageComposite.setLayoutData((Object)gridData);
        imageComposite.setBackgroundImage(imageTitle);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        QuickStartDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.oldDialogArea(parent);
        GridLayout glDialogComposite = (GridLayout)dialogComposite.getLayout();
        glDialogComposite.numColumns = 4;
        glDialogComposite.marginHeight = 0;
        glDialogComposite.marginWidth = 0;
        glDialogComposite.verticalSpacing = 0;
        glDialogComposite.horizontalSpacing = 0;
        Composite stepTreeComposite = this.createStepTableComposite(dialogComposite);
        this.layoutTreeAreaControl((Control)stepTreeComposite);
        this.createSash(dialogComposite, (Control)stepTreeComposite);
        Label label = new Label(dialogComposite, 2);
        label.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.createWizardArea(dialogComposite);
        return dialogComposite;
    }

    private Composite createStepTableComposite(Composite dialogComposite) {
        Composite stepTreeComposite = new Composite(dialogComposite, 0);
        stepTreeComposite.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        stepTreeComposite.setLayout((Layout)new GridLayout(1, false));
        stepTreeComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.tableViewer = new CTableViewer(stepTreeComposite, 65536);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.pageViewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.pageViewerColumn.getColumn().setWidth(220);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return stepTreeComposite;
    }

    protected Composite createStepAreaComposite(Composite dialogComposite) {
        this.stepArea = new Composite(dialogComposite, 0);
        GridLayout glStepArea = new GridLayout(1, false);
        glStepArea.horizontalSpacing = 0;
        glStepArea.verticalSpacing = 0;
        glStepArea.marginWidth = 0;
        glStepArea.marginHeight = 0;
        this.stepArea.setLayout((Layout)glStepArea);
        this.stepArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label separator = new Label(this.stepArea, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.stepDetailsComposite = new Composite(this.stepArea, 0);
        this.stepDetailsComposite.setLayout((Layout)new FillLayout(256));
        this.stepDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return this.stepArea;
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gd = new GridData(1040);
        gd.horizontalAlignment = 4;
        gd.widthHint = this.getLastRightWidth();
        gd.verticalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected int getLastRightWidth() {
        return this.lastTreeWidth;
    }

    protected Sash createSash(final Composite composite, final Control rightControl) {
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.setBackground(composite.getDisplay().getSystemColor(25));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)rightControl.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 20) {
                    return;
                }
                Point computedSize = QuickStartDialog.this.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = QuickStartDialog.this.getShell().getSize()));
                data.widthHint = newWidthHint;
                QuickStartDialog.this.setLastTreeWidth(newWidthHint);
                composite.layout(true);
                computedSize = QuickStartDialog.this.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
                QuickStartDialog.this.setShellSize(computedSize.x, computedSize.y);
            }
        });
        return sash;
    }

    protected void setLastTreeWidth(int newWidthHint) {
        this.lastTreeWidth = newWidthHint;
    }

    private void setShellSize(int width, int height) {
        Rectangle preferred = this.getShell().getBounds();
        preferred.width = width;
        preferred.height = height;
        this.getShell().setBounds(this.getConstrainedShellBounds(preferred));
    }

    protected void registerControlModifyListeners() {
        super.registerControlModifyListeners();
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                TableItem item = QuickStartDialog.this.tableViewer.getTable().getItem(new Point(e.x, e.y));
                IWizardPage selectedPage = (IWizardPage)item.getData();
                QuickStartDialog.this.showPage(selectedPage);
                QuickStartDialog.this.tableViewer.setSelection((ISelection)new StructuredSelection());
                Trackings.trackQuickStartAction((String)selectedPage.getClass().getSimpleName());
            }
        });
        this.tableViewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
            }
        });
        this.tableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 32;
            }
        });
        this.tableViewer.getTable().forceFocus();
    }

    protected Collection<IWizardPage> getWizardPages() {
        return Arrays.asList(new WebTestingWizardPage(), new APITestingWizardPage(), new MobileTestingWizardPage(), new DesktopAppsTestingPage(), new DatadrivenTestingWizardPage(), new BDDTestingWizardPage(), new SDLCIntergrationWizardPage(), new PluginStoreWizardPage(), new AdvancedReportWizardPage());
    }

    protected void setInput() {
        super.setInput();
        this.pageViewerColumn.setLabelProvider((CellLabelProvider)new WizardTableLabelTest(this.wizardManager));
        this.tableViewer.setInput((Object)this.wizardManager.getWizardPages());
    }

    protected void showPage(IWizardPage page) {
        this.wizardManager.choosenPage(this.wizardManager.getWizardPages().indexOf(page));
        this.doShowPage(page);
        this.tableViewer.refresh(true);
    }

    private void doShowPage(IWizardPage page) {
        super.showPage(page);
    }

    protected Point getInitialSize() {
        return new Point(1050, 750);
    }

    protected String getDialogTitle() {
        return "Katalon Studio Quick Start";
    }

    public String getStepIndexAsString() {
        return null;
    }

    public boolean isChild() {
        return false;
    }

    protected void finishPressed() {
        super.okPressed();
    }

    public boolean close() {
        Trackings.trackQuickStartAction((String)"skip");
        return super.close();
    }

    protected void nextPressed() {
        Trackings.trackQuickStartAction((String)"next");
        super.nextPressed();
    }
}

