/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.application.userprofile.UserExperienceLevel;
import com.kms.katalon.composer.components.impl.overlay.OverlayShell;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.entity.project.QuickStartProjectType;
import java.net.URI;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuickStartDialogV3
extends Dialog {
    private static final String DEEP_LINK_SURVEY_PREFIX = "katalonstudio://survey";
    private static final String ONBOARD_PATH = "/onboard";
    private static final String CLOSE_PATH = "/close";
    private static final String NAVIGATE_PATH = "/navigate";
    private static final String FIRST_PROJECT_PARAM = "firstProject";
    private static final String FIRST_PROJECT_VALUE_WEB = "web-testing";
    private static final String FIRST_PROJECT_VALUE_MOBILE = "mobile-testing";
    private static final String FIRST_PROJECT_VALUE_API = "api-testing";
    private static final String FIRST_PROJECT_VALUE_DESKTOP = "desktop-testing";
    private static final String FIRST_PROJECT_VALUE_BDD = "bdd-testing";
    private static final String DEST_PARAM = "dest";
    private static final Map<String, QuickStartProjectType> projectTypeMap = Map.of("web-testing", QuickStartProjectType.WEBUI, "mobile-testing", QuickStartProjectType.MOBILE, "api-testing", QuickStartProjectType.API, "desktop-testing", QuickStartProjectType.DESKTOP, "bdd-testing", QuickStartProjectType.BDD);
    private Browser browser;
    private int dialogWidth;
    private int dialogHeight;
    private boolean closeable;
    private UserExperienceLevel userLevel = UserExperienceLevel.EXPERIENCED;
    private QuickStartProjectType projectType = QuickStartProjectType.WEBUI;
    private boolean finishedOnboardingSurvey = false;

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public UserExperienceLevel getUserLevel() {
        return this.userLevel;
    }

    public QuickStartProjectType getProjectType() {
        return this.projectType;
    }

    public boolean isFinishedOnboardingSurvey() {
        return this.finishedOnboardingSurvey;
    }

    public QuickStartDialogV3(Shell parentShell, int dialogWidth, int dialogHeight, boolean closeable) {
        super(QuickStartDialogV3.initBackdrop(parentShell));
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.closeable = closeable;
    }

    protected static Shell initBackdrop(Shell parentShell) {
        if (SystemUtils.IS_OS_LINUX) {
            return parentShell;
        }
        OverlayShell backdrop = new OverlayShell((Control)parentShell, 32768);
        backdrop.setBackground(ColorUtil.themeColor((String)"#E3E3E3", (String)"#000"));
        backdrop.setAlpha(200);
        backdrop.open();
        return backdrop.getShell();
    }

    public boolean close() {
        if (!SystemUtils.IS_OS_LINUX) {
            this.getParentShell().close();
        }
        this.browser.close();
        return super.close();
    }

    protected int getShellStyle() {
        int canCloseBit = this.isCloseable() ? 64 : 0;
        int canResizeBit = this.isResizable() ? 16 : 0;
        return 0x8020 | canCloseBit | canResizeBit;
    }

    protected boolean isCloseable() {
        return this.closeable;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(ComponentUtil.applyScaleFactor((int)this.dialogWidth), ComponentUtil.applyScaleFactor((int)this.dialogHeight));
    }

    public int open() {
        Shell shell = this.getShell();
        this.centerDialog(shell);
        return super.open();
    }

    private void centerDialog(Shell shell) {
        Rectangle parentBounds = this.getParentShell().getBounds();
        int x = parentBounds.x + (parentBounds.width - this.dialogWidth) / 2;
        int y = parentBounds.y + (parentBounds.height - this.dialogHeight) / 2;
        shell.setLocation(x, y);
    }

    protected Control createContents(Composite container) {
        this.browser = (Browser)ComponentBuilder.browser((Composite)container, (int)327688).fill().build();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (!location.startsWith(QuickStartDialogV3.DEEP_LINK_SURVEY_PREFIX)) {
                    return;
                }
                event.doit = false;
                QuickStartDialogV3.this.handleCallbackUrl(location);
            }

            public void changed(LocationEvent event) {
            }
        });
        return container;
    }

    private void handleCallbackUrl(String location) {
        try {
            URI uri = new URI(location);
            String path = uri.getPath();
            URIBuilder uriBuilder = new URIBuilder(uri);
            Map<String, String> queryParams = uriBuilder.getQueryParams().stream().collect(Collectors.toMap(param -> param.getName(), param -> param.getValue()));
            if (ONBOARD_PATH.equals(path)) {
                if (queryParams.containsKey(FIRST_PROJECT_PARAM)) {
                    String firstProject = queryParams.get(FIRST_PROJECT_PARAM);
                    this.userLevel = UserExperienceLevel.FRESHER;
                    QuickStartProjectType quickStartProjectType = projectTypeMap.getOrDefault(firstProject, null);
                    if (quickStartProjectType != null) {
                        this.projectType = quickStartProjectType;
                        this.finishedOnboardingSurvey = true;
                    }
                }
                this.close();
            } else if (NAVIGATE_PATH.equals(path)) {
                if (queryParams.containsKey(DEST_PARAM)) {
                    String dest = queryParams.get(DEST_PARAM);
                    Program.launch((String)dest);
                }
            } else if (CLOSE_PATH.equals(path)) {
                this.close();
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Error when handle the callback");
        }
    }
}

