/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.kms.katalon.composer.components.impl.overlay.ContextMenu;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.handlers.OpenG2ReviewDialogHandler;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import jakarta.inject.Inject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class G2ReviewPopover
extends ContextMenu {
    @Inject
    private OpenG2ReviewDialogHandler g2ReviewDialogHandler;
    @Inject
    private IDiscoveryController discoveryController;

    public G2ReviewPopover(Shell parent, Widget target, int style, int preferedPosition) {
        super(parent, target, style, preferedPosition, true);
    }

    protected void createInnerContent(Composite parent) {
        int titleFontSize = OSUtil.isWindows() ? 12 : 15;
        int messageFontSize = OSUtil.isWindows() ? 11 : 14;
        String popoverTitle = MessageConstants.G2_REVIEW_POPOVER_TITLE;
        String popoverMessage = MessageConstants.G2_REVIEW_POPOVER_DESCRIPTION;
        boolean enablePopoverButton = true;
        boolean isInternetAvailable = this.isInternetAvailable();
        if (!isInternetAvailable) {
            popoverTitle = MessageConstants.OFFLINE_POPOVER_TITLE;
            popoverMessage = MessageConstants.OFFLINE_POPOVER_MESSAGE;
            enablePopoverButton = false;
        }
        ComponentBuilder.label((Composite)parent).text(popoverTitle).fontSize(titleFontSize).bold().margin(ComponentUtil.applyZoom((int)7), ComponentUtil.applyZoom((int)10), ComponentUtil.applyZoom((int)7)).fillHorizontal().center().build();
        ComponentBuilder.separator((Composite)parent).build();
        Composite messageContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).width(320).margin(ComponentUtil.applyZoom((int)7), ComponentUtil.applyZoom((int)10), ComponentUtil.applyZoom((int)7)).fillHorizontal().build();
        ComponentBuilder messageFieldBuilder = ComponentBuilder.label((Composite)messageContainer).text(popoverMessage).fontSize(messageFontSize).fillHorizontal();
        if (!isInternetAvailable) {
            messageFieldBuilder.textCenter();
        }
        messageFieldBuilder.build();
        if (enablePopoverButton) {
            Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).fillHorizontal().margin(ComponentUtil.applyZoom((int)10)).build();
            ComponentBuilder.canvas((Composite)buttonBar).text(MessageConstants.G2_REVIEW_POPOVER_BTN_LET_GO).center().applyPrimaryButtonStyle3WithCustomDisableColors(ColorUtil.getTextWhiteColor(), ColorUtil.getColor((String)"#2236E5"), ColorUtil.getColor((String)"#2133D1")).autoSizeMD(150).height(30).onClick(event -> {
                this.g2ReviewDialogHandler.execute();
                this.fakeClose();
            }).build();
        }
    }

    private boolean isInternetAvailable() {
        try {
            return this.discoveryController.isOnline("https://backend.katalon.com");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

