/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.jobs;

import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdateException;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.jobs.CheckForUpdatesJob;
import com.kms.katalon.composer.update.models.AppInfo;
import com.kms.katalon.composer.update.models.FileInfo;
import com.kms.katalon.composer.update.models.VersionInfo;
import com.kms.katalon.composer.update.util.ExtractUtils;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IDownloadProgress;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class DownloadUpdateJob
extends Job
implements UpdateComponent {
    private CheckForUpdatesJob.CheckForUpdateResult newUpdateResult;
    IHttpClient httpClient = ApacheHttpClient.getInstance();
    INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();

    public DownloadUpdateJob(CheckForUpdatesJob.CheckForUpdateResult newUpdateResult) {
        super("Downloading Update...");
        this.newUpdateResult = newUpdateResult;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            subMonitor.beginTask("", 100);
            SubMonitor downloadMonitor = subMonitor.split(80, 0);
            downloadMonitor.beginTask("Downloading Update Files...", 100);
            File downloadDir = this.getUpdateManager().getLocalDownloadDir(this.getLatestVersion());
            downloadDir.mkdir();
            FileUtils.cleanDirectory((File)downloadDir);
            long totalSize = this.newUpdateResult.getUpdateFiles().stream().mapToLong(f -> f.getSize()).reduce((a, b) -> a + b).getAsLong();
            for (FileInfo fileInfo : this.newUpdateResult.getUpdateFiles()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                int subWork = Math.round((float)fileInfo.getSize() / (float)totalSize * 100.0f);
                SubMonitor downloadFileMonitor = downloadMonitor.newChild(subWork, 2);
                try {
                    this.downloadFile(fileInfo, new DownloadProgress(downloadFileMonitor, fileInfo));
                }
                catch (UpdateException updateException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
                downloadFileMonitor.done();
            }
            downloadMonitor.done();
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            SubMonitor extractMonitor = subMonitor.split(20, 4);
            extractMonitor.beginTask("Extracting Update Files...", 100);
            File extractDir = this.getUpdateManager().getLocalExtractDir(this.getLatestVersion());
            extractDir.mkdir();
            FileUtils.cleanDirectory((File)extractDir);
            for (FileInfo fileInfo : this.newUpdateResult.getUpdateFiles()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                File downloadedFileInfo = new File(downloadDir, fileInfo.getLocation());
                ExtractUtils.extract(downloadedFileInfo, extractDir);
                int subWork = Math.round((float)fileInfo.getSize() / (float)totalSize * 100.0f);
                extractMonitor.worked(subWork);
            }
            FileUtils.cleanDirectory((File)downloadDir);
            this.replaceUpdater(extractDir);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException e) {
            Status status = new Status(4, "com.kms.katalon", "Unable to download update file from Katalon server", (Throwable)new UpdateException(e));
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private void replaceUpdater(File extractDir) {
        try {
            File newUpdaterDir = new File(extractDir, "resources/update/updater");
            File oldUpdaterDir = this.getUpdateManager().getUpdateJar().getParentFile();
            if (newUpdaterDir.exists() && newUpdaterDir.isDirectory()) {
                FileUtils.copyDirectory((File)newUpdaterDir, (File)oldUpdaterDir);
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String getLatestVersion() {
        return this.newUpdateResult.getLatestAppInfo().getVersion();
    }

    private void downloadFile(FileInfo fileInfo, DownloadProgress progress) throws UpdateException {
        File localFileInfo;
        UpdateManager updateManager = this.getUpdateManager();
        try {
            AppInfo latestAppInfo = this.newUpdateResult.getLatestAppInfo();
            localFileInfo = updateManager.getLocalDownloadFileInfo(latestAppInfo.getVersion(), fileInfo.getLocation());
            localFileInfo.getParentFile().mkdirs();
        }
        catch (IOException e) {
            throw new UpdateException(e);
        }
        VersionInfo latestVersionInfo = this.newUpdateResult.getLatestVersionInfo();
        String latestUpdateLocation = this.getLatestUpdateLocation(latestVersionInfo);
        String fileInfoUrl = updateManager.getFileInfoVersionUrl(latestUpdateLocation, PlatformUtil.getPlatform(), fileInfo.getLocation());
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (FileOutputStream outputStream = new FileOutputStream(localFileInfo);){
                URI uri = new URI(fileInfoUrl);
                ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
                HttpOptions httpOptions = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig).build();
                this.httpClient.download(uri, (OutputStream)outputStream, httpOptions, (IDownloadProgress)progress);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HttpException | IOException | URISyntaxException e) {
            throw new UpdateException((Exception)e);
        }
    }

    class DownloadProgress
    implements IDownloadProgress {
        SubMonitor monitor;
        FileInfo fileInfo;
        long totalBytes;
        int currentWork = 0;

        public DownloadProgress(SubMonitor monitor, FileInfo fileInfo) {
            this.monitor = monitor;
            this.fileInfo = fileInfo;
        }

        public void start(long totalBytes) {
            this.totalBytes = totalBytes;
            this.monitor.beginTask("", 100);
        }

        public void update(long bytesRead) {
            int work = Math.round((float)bytesRead / (float)this.totalBytes * 100.0f);
            int nextWork = work - this.currentWork;
            if (nextWork > 0) {
                this.monitor.worked(nextWork);
                this.monitor.subTask(this.fileInfo.getLocation());
            }
            this.currentWork = work;
        }

        public void finish() {
            this.monitor.done();
        }
    }
}

