/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.imp.wizard;

import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientAuthException;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import com.kms.katalon.activation.plugin.service.KStoreRestClient;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.handlers.RequireAuthorizationHandler;
import com.kms.katalon.execution.constants.StringConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RecommendPluginsDialog
extends Dialog {
    List<Long> idProduct = new ArrayList<Long>();
    public static final int NEW_PROJECT_ID = 1025;
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    public static final int OPEN_PROJECT_ID = 1026;
    protected Button newButton;
    protected Composite stepDetailsComposite;
    protected ScrolledComposite scrolledComposite;
    protected HashMap<String, Object> sharedData;

    public RecommendPluginsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Most recommended plugins");
    }

    protected Control createButtonBar(Composite parent) {
        Composite labelComposite = new Composite(parent, 0);
        labelComposite.setLayoutData((Object)new GridData(16384, 1024, true, false));
        labelComposite.setLayout((Layout)new GridLayout());
        Composite buttonBarComposite = new Composite(parent, 0);
        buttonBarComposite.setLayoutData((Object)new GridData(131072, 1024, true, false));
        buttonBarComposite.setLayout((Layout)new GridLayout());
        Label lb = new Label(labelComposite, 0);
        lb.setText(StringConstants.DIA_INTRO_PROJECT);
        this.createButtonsForButtonBar(buttonBarComposite);
        return buttonBarComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Install", true);
    }

    public final void installPressed() {
        final Job reloadPluginsJob = new Job("Reloading plugins..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    KStoreApiKeyCredentials credential = RequireAuthorizationHandler.getApiKeyCredential();
                    KStoreRestClient res = new KStoreRestClient((KStoreCredentials)credential);
                    res.postRecommended(RecommendPluginsDialog.this.idProduct);
                    LoggerSingleton.logInfo((String)"Reloaded plugins successfully.");
                    return Status.OK_STATUS;
                }
                catch (KStoreClientAuthException | KStoreClientException e) {
                    LoggerSingleton.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        reloadPluginsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                EventBrokerSingleton.getInstance().getEventBroker().post("WORKSPACE/PLUGIN_LOADED", null);
                if (!reloadPluginsJob.getResult().isOK()) {
                    LoggerSingleton.logError((String)"Failed to reload plugins.");
                    return;
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                });
            }
        });
        reloadPluginsJob.setUser(true);
        reloadPluginsJob.schedule();
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    public void create() {
        super.create();
    }

    protected void createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    public Control createStepArea(Composite parent) {
        try {
            KStoreApiKeyCredentials credentials = RequireAuthorizationHandler.getApiKeyCredential();
            KStoreRestClient res = new KStoreRestClient((KStoreCredentials)credentials);
            final List recommendList = res.getRecommendPlugins();
            final ArrayList<Button> buttons = new ArrayList<Button>();
            int i = 0;
            while (i < recommendList.size()) {
                this.newButton = new Button(parent, 96);
                this.newButton.setText(((KStoreProduct)recommendList.get(i)).getName());
                this.newButton.setSelection(true);
                Label lb = new Label(parent, 64);
                GridData gdLb = new GridData(4, 128, false, false);
                gdLb.widthHint = 530;
                lb.setLayoutData((Object)gdLb);
                lb.setText("    " + ((KStoreProduct)recommendList.get(i)).getDescription());
                lb.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
                this.idProduct.add(((KStoreProduct)recommendList.get(i)).getId());
                buttons.add(this.newButton);
                ((Button)buttons.get(i)).addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int i = 0;
                        while (i < recommendList.size()) {
                            if (!((Button)buttons.get(i)).getSelection()) {
                                RecommendPluginsDialog.this.idProduct.remove(((KStoreProduct)recommendList.get(i)).getId());
                            }
                            if (((Button)buttons.get(i)).getSelection() && !RecommendPluginsDialog.this.idProduct.contains(((KStoreProduct)recommendList.get(i)).getId())) {
                                RecommendPluginsDialog.this.idProduct.add(((KStoreProduct)recommendList.get(i)).getId());
                            }
                            ++i;
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                ++i;
            }
        }
        catch (KStoreClientException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        catch (KStoreClientAuthException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return this.stepDetailsComposite;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(580, initialSize.x), initialSize.y);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)this.scrolledComposite, 2048);
        GridLayout girdLayout = new GridLayout();
        girdLayout.marginLeft = 5;
        composite.setLayout((Layout)girdLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createStepArea(composite);
        this.scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        this.scrolledComposite.setContent((Control)composite);
        return composite;
    }
}

