/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.constants.WebServerConstant;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;

public class RemoteFileHandler
extends CustomHttpHandler {
    @Inject
    INetworkPreferences networkPreferences;
    @Inject
    private IHttpClient httpClient;
    private URL url;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        byte[] content = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> entry : req.getRequest().getRequestHeaders().entrySet()) {
                String headerName = entry.getKey();
                List<String> headerValues = entry.getValue();
                headers.put(headerName, headerValues.stream().collect(Collectors.joining(",")));
            }
            headers.put("Host", this.url.getHost());
            headers.remove("If-Modified-Since");
            headers.remove("If-modified-since");
            headers.remove("If-None-Match");
            headers.remove("If-none-match");
            headers.put("Cache-Control", "no-store, no-cache, max-age=0, must-revalidate, proxy-revalidate");
            HttpResponse res = this.getResource(req, headers);
            content = res.getBody().getBytes(StandardCharsets.UTF_8);
            for (Map.Entry header : res.getHeaders()) {
                req.setHeader((String)header.getKey(), header.getValue());
            }
        }
        catch (HttpException e) {
            req.send(e.getStatusCode(), WebServerConstant.MSG_CAN_NOT_LOAD_RESOURCE);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            req.send(500, "Internal server error");
            return;
        }
        req.send(content);
    }

    private HttpResponse getResource(CustomRequest req, Map<String, String> headers) throws IOException, URISyntaxException, HttpException {
        if (this.url == null) {
            throw new IllegalStateException("URL for the remote S3 is not set.");
        }
        URI uri = new URIBuilder(req.getURI()).setScheme(this.url.getProtocol()).setHost(this.url.getHost()).setPort(this.url.getPort()).build();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        if (!req.getMethod().equalsIgnoreCase("GET")) {
            throw new UnsupportedOperationException(MessageFormat.format("Unsupported method {0}", req.getMethod()));
        }
        return this.httpClient.get(uri, httpOptions);
    }

    public void setRemoteUrl(URL url) {
        this.url = url;
    }
}

