/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.ai.core.dto.StudioAssistChatCancelQuestionRequest;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatCancelQuestionHandler
extends CustomHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatCancelQuestionHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        try {
            StudioAssistChatCancelQuestionRequest request = (StudioAssistChatCancelQuestionRequest)JsonUtil.fromJson((String)req.getRequestDataAsString(), StudioAssistChatCancelQuestionRequest.class);
            if (!this.validate(req, request)) {
                this.logger.debug("validate failed | request = %s".formatted(JsonUtil.toJson((Object)request)));
                return;
            }
            this.eventBroker.post("ON_CHAT_CANCEL_QUESTION", (Object)request);
            req.end();
        }
        catch (Exception e) {
            this.logger.error("%s | %s | %s".formatted("Exception while handle cancel question", req.getRequestDataAsString(), e.getMessage()), (Throwable)e);
            req.sendResponseHeaders(500, -1);
        }
    }

    private boolean validate(CustomRequest req, StudioAssistChatCancelQuestionRequest request) throws IOException {
        if (request == null || StringUtils.isBlank((CharSequence)request.getConversationId()) || StringUtils.isBlank((CharSequence)request.getQuestionMsgId())) {
            req.sendResponseHeaders(400, -1);
            return false;
        }
        return true;
    }
}

