/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.core.services.ITestOpsSettingStore;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.TestOpsSearchRequest;
import jakarta.inject.Inject;
import java.io.IOException;

public class TestOpsProjectInfoHandler
extends CustomHttpHandler {
    @Inject
    private ITestOpsController testOpsController;
    private ITestOpsSettingStore testOpsSettingStore;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        if (this.handlePrefightRequestAndCORS(req)) {
            return;
        }
        this.testOpsSettingStore = AnalyticsSettingStore.getStore();
        AnalyticsProject project = this.testOpsSettingStore.getProject();
        try {
            TestOpsSearchRequest requestedInfo = TestOpsSearchRequest.valueOf(req.query("info"));
            switch (requestedInfo) {
                case GET_3_LATEST_EXECUTIONS: {
                    req.send(this.testOpsController.getCompletedExecutions(project.getId(), 3));
                    break;
                }
                case GET_PROJECT_STATISTICS_IN_LAST_7_DAYS: {
                    req.send(this.testOpsController.getProjectStatisticsInLast7Days(project.getId()));
                    break;
                }
                case GET_TOTAL_EXECUTIONS_STATISTICS_IN_LAST_7_DAYS: {
                    req.send(this.testOpsController.getTotalExecutionsStatistics(project.getId()));
                    break;
                }
                case GET_6_LATEST_EXECUTIONS_TEST_SUITE: {
                    String testSuitePath = req.query("testSuitePath");
                    String testSuiteName = req.query("testSuiteName");
                    if (testSuitePath == null || testSuiteName == null) break;
                    req.send(this.testOpsController.getCompletedExecutionTestSuite(project.getId(), testSuitePath, testSuiteName, 6));
                    break;
                }
            }
            req.end();
        }
        catch (Exception error) {
            LogUtil.logError((Throwable)error);
            TestOpsMessageError testOpsMessageError = new TestOpsMessageError();
            testOpsMessageError.setMessage(error.getMessage());
            testOpsMessageError.setException(error);
            testOpsMessageError.setHasError(true);
            req.send(testOpsMessageError);
        }
    }
}

