/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element;

import com.kms.katalon.core.testobject.SelectorCollector;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.objectspy.element.HTMLFrameElement;
import com.kms.katalon.objectspy.element.HTMLPageElement;
import com.kms.katalon.objectspy.element.XPathProvider;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.w3c.dom.Element;

public class HTMLElement
implements SelectorCollector,
XPathProvider {
    private static final String AND_OPERATOR = " and ";
    private static final String TEXT_METHOD = "text";
    private static final String CSS_SELECTOR = "css";
    private static final String XPATH_SELECTOR = "xpath";
    private static final String XPATH_FIND_BY_ATTRIBUTE = "@{0}=''{1}''";
    private static final String XPATH_FIND_BY_TEXT = "text()=''{0}''";
    private static final String XPATH_EXPRESSION = "//{0}[{1}]";
    private SelectorMethod selectorMethod = SelectorMethod.BASIC;
    private Map<SelectorMethod, String> selectorCollection = new HashMap<SelectorMethod, String>();
    protected String name;
    protected String type;
    protected String xpath;
    protected Map<String, String> attributes;
    protected HTMLFrameElement parentElement;
    private MatchedStatus matchedStatus;

    protected HTMLElement() {
        this("", "", Collections.emptyMap(), null);
    }

    public HTMLElement(String name, String type, Map<String, String> attributes, HTMLFrameElement parentElement) {
        this.name = name;
        this.type = type;
        this.parentElement = parentElement;
        if (parentElement != null) {
            parentElement.getChildElements().add(this);
        }
        this.attributes = new LinkedHashMap<String, String>(attributes);
        this.matchedStatus = new MatchedStatus();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public HTMLFrameElement getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(HTMLFrameElement parentElement) {
        this.parentElement = parentElement;
    }

    @Override
    public String getXpath() {
        StringBuilder xpathBuilder = new StringBuilder();
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            String attributeKey = attr.getKey();
            String attributeValue = attr.getValue();
            switch (attributeKey) {
                case "xpath": {
                    return attributeValue;
                }
                case "text": {
                    this.appendAndOperator(xpathBuilder);
                    xpathBuilder.append(MessageFormat.format(XPATH_FIND_BY_TEXT, attributeValue));
                    break;
                }
                default: {
                    this.appendAndOperator(xpathBuilder);
                    xpathBuilder.append(MessageFormat.format(XPATH_FIND_BY_ATTRIBUTE, attributeKey, attributeValue));
                }
                case "css": 
            }
        }
        return MessageFormat.format(XPATH_EXPRESSION, StringUtils.defaultIfEmpty((String)this.getType(), (String)"*"), xpathBuilder.toString());
    }

    private void appendAndOperator(StringBuilder xpathBuilder) {
        if (StringUtils.isNotEmpty((String)xpathBuilder.toString())) {
            xpathBuilder.append(AND_OPERATOR);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof HTMLElement)) {
            return false;
        }
        HTMLElement that = (HTMLElement)object;
        return new EqualsBuilder().append((Object)this.getParentElement(), (Object)that.getParentElement()).append((Object)this.getName(), (Object)that.getName()).append((Object)this.getXpath(), (Object)that.getXpath()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append(this.getParentElement() != null ? Integer.valueOf(this.getParentElement().hashCode()) : this.xpath).toHashCode();
    }

    public HTMLPageElement getParentPageElement() {
        if (this.getParentElement() instanceof HTMLPageElement) {
            return (HTMLPageElement)this.getParentElement();
        }
        if (this.getParentElement() != null) {
            return this.getParentElement().getParentPageElement();
        }
        return null;
    }

    public String getTypeAttribute() {
        if (this.type.toLowerCase().equals("input")) {
            return this.attributes.get("type");
        }
        return "";
    }

    public MatchedStatus getMatchedStatus() {
        return this.matchedStatus;
    }

    public HTMLElement softClone() {
        return new HTMLElement(this.getName(), this.getType(), this.getAttributes(), null);
    }

    public SelectorMethod getSelectorMethod() {
        return this.selectorMethod;
    }

    public void setSelectorMethod(SelectorMethod selectorMethod) {
        this.selectorMethod = selectorMethod;
    }

    public void setSelectorValue(SelectorMethod selectorMethod, String selectorValue) {
        this.selectorCollection.put(selectorMethod, selectorValue);
    }

    public Map<SelectorMethod, String> getSelectorCollection() {
        return this.selectorCollection;
    }

    @Override
    public HTMLElement getParent() {
        return this.parentElement;
    }

    public static enum HTMLStatus {
        NotVerified,
        Exists,
        Missing,
        Changed,
        Multiple,
        Invalid;

    }

    public class MatchedStatus {
        private HTMLStatus status;
        private Element matchedElement;

        public MatchedStatus() {
            this.reset();
        }

        public void reset() {
            this.status = HTMLStatus.NotVerified;
            this.matchedElement = null;
        }

        public HTMLStatus getStatus() {
            return this.status;
        }

        public void setStatus(HTMLStatus status) {
            this.status = status;
        }

        public Element getMatchedElement() {
            return this.matchedElement;
        }

        public void setMatchedElement(Element matchedElement) {
            this.matchedElement = matchedElement;
        }
    }
}

