/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.websocket;

import com.kms.katalon.objectspy.websocket.AddonHotKeyConfig;

public class AddonHotKeyData {
    private int keyCode;
    private boolean useAltKey = false;
    private boolean useShiftKey = false;
    private boolean useCtrlKey = false;
    private boolean useMetaKey = false;

    public static AddonHotKeyData buildFrom(AddonHotKeyConfig hotkeyConfig) {
        AddonHotKeyData hotkeyData = new AddonHotKeyData();
        hotkeyData.setKeyCode(hotkeyConfig.getKeyCode());
        int modifiers = hotkeyConfig.getModifiers();
        hotkeyData.setUseAltKey((modifiers & 0x10000) != 0);
        hotkeyData.setUseCtrlKey((modifiers & 0x40000) != 0);
        hotkeyData.setUseMetaKey((modifiers & 0x400000) != 0);
        hotkeyData.setUseShiftKey((modifiers & 0x20000) != 0);
        return hotkeyData;
    }

    private static int convertSWTKeyCodeToJsKeyCode(int swtKeyCode) {
        if (swtKeyCode == 96) {
            return 192;
        }
        if (swtKeyCode >= 97 && swtKeyCode <= 122) {
            return swtKeyCode - 32;
        }
        return swtKeyCode;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = AddonHotKeyData.convertSWTKeyCodeToJsKeyCode(keyCode);
    }

    public boolean isUseAltKey() {
        return this.useAltKey;
    }

    public void setUseAltKey(boolean useAltKey) {
        this.useAltKey = useAltKey;
    }

    public boolean isUseShiftKey() {
        return this.useShiftKey;
    }

    public void setUseShiftKey(boolean useShiftKey) {
        this.useShiftKey = useShiftKey;
    }

    public boolean isUseCtrlKey() {
        return this.useCtrlKey;
    }

    public void setUseCtrlKey(boolean useCtrlKey) {
        this.useCtrlKey = useCtrlKey;
    }

    public boolean isUseMetaKey() {
        return this.useMetaKey;
    }

    public void setUseMetaKey(boolean useMetaKey) {
        this.useMetaKey = useMetaKey;
    }
}

