/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.network.oauth.services;

import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.services.IHttpClient;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPRequest;
import com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPResponse;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.util.EntityUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class NimbusHttpClient
implements HTTPRequestSender {
    @Inject
    private IHttpClient httpClient;
    private HttpOptions httpOptions;

    public static NimbusHttpClient withOptions(HttpOptions httpOptions) {
        BundleContext bundleContext = FrameworkUtil.getBundle(NimbusHttpClient.class).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        NimbusHttpClient client = new NimbusHttpClient();
        ContextInjectionFactory.inject((Object)client, (IEclipseContext)eclipseContext);
        client.httpOptions = httpOptions;
        return client;
    }

    public ReadOnlyHTTPResponse send(ReadOnlyHTTPRequest httpRequest) throws IOException {
        String body;
        RequestBuilder builder = switch (httpRequest.getMethod()) {
            case HTTPRequest.Method.GET -> RequestBuilder.get();
            case HTTPRequest.Method.POST -> RequestBuilder.post();
            case HTTPRequest.Method.PUT -> RequestBuilder.put();
            case HTTPRequest.Method.DELETE -> RequestBuilder.delete();
            default -> throw new IOException("Unsupported HTTP method: " + String.valueOf(httpRequest.getMethod()));
        };
        builder.setUri(httpRequest.getURI());
        for (Map.Entry en : httpRequest.getHeaderMap().entrySet()) {
            String headerName = (String)en.getKey();
            List headerValues = (List)en.getValue();
            if (CollectionUtils.isEmpty((Collection)headerValues)) continue;
            for (String headerValue : headerValues) {
                builder.setHeader(headerName, headerValue);
            }
        }
        if (httpRequest.getBody() != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(httpRequest.getBody().getBytes(StandardCharsets.UTF_8)));
            builder.setEntity((HttpEntity)entity);
        }
        HttpUriRequest request = builder.build();
        HttpResponse response = this.httpClient.execute(request, this.httpOptions);
        StatusLine statusLine = response.getStatusLine();
        HTTPResponse httpResponse = new HTTPResponse(statusLine.getStatusCode());
        httpResponse.setStatusMessage(statusLine.getReasonPhrase());
        Header[] headerArray = response.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            httpResponse.setHeader(header.getName(), new String[]{header.getValue()});
            ++n2;
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null && StringUtils.isNotBlank((CharSequence)(body = EntityUtils.toString((HttpEntity)httpEntity)))) {
            httpResponse.setBody(body);
        }
        return httpResponse;
    }
}

