/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.apache.services;

import com.kms.katalon.network.apache.services.HttpProxyConfigurator;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BasicAuthentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IDownloadProgress;
import com.kms.katalon.network.core.services.IHttpClient;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class ApacheHttpClient
implements IHttpClient {
    private static PoolingHttpClientConnectionManager connectionManager;
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static IHttpClient instance;
    private static SSLContext sc;
    private static boolean kerberosSupported;

    static {
        try {
            sc = SSLContext.getInstance("TLS");
            sc.init(ApacheHttpClient.getKeyManagers(), ApacheHttpClient.getTrustManagers(), null);
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception exception) {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setValidateAfterInactivity(1);
        connectionManager.setMaxTotal(2000);
        connectionManager.setDefaultMaxPerRoute(500);
    }

    public static IHttpClient getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(ApacheHttpClient.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IHttpClient)ContextInjectionFactory.make(ApacheHttpClient.class, (IEclipseContext)context);
        }
        return instance;
    }

    public static SSLContext getSslContext() {
        return sc;
    }

    public static boolean isKerberosSupported() {
        return kerberosSupported;
    }

    public static void setKerberosSupported(boolean isKerberosSupported) {
        kerberosSupported = isKerberosSupported;
    }

    private static KeyManager[] getKeyManagers() throws GeneralSecurityException, IOException {
        return new KeyManager[0];
    }

    private static TrustManager[] getTrustManagers() throws IOException {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
    }

    public com.kms.katalon.network.core.model.HttpResponse delete(URI url, HttpOptions options) throws HttpException {
        HttpDelete request = new HttpDelete(url);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public void download(URI url, OutputStream os, HttpOptions options, IDownloadProgress progress) throws HttpException {
        block34: {
            HttpGet request = new HttpGet(url);
            this.applyHeaders((HttpRequestBase)request, options);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (CloseableHttpClient client = this.createHttpClient(request.getURI(), options);){
                    HttpClientContext clientContext = options.getProxy() == null ? null : HttpProxyConfigurator.getInstance().createClientContextWithProxyAuth(options.getProxy(), request.getURI(), kerberosSupported);
                    try {
                        Throwable throwable2 = null;
                        Object var11_16 = null;
                        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)clientContext);){
                            HttpEntity entity = response.getEntity();
                            if (entity == null) break block34;
                            long contentLength = entity.getContentLength();
                            if (Objects.nonNull(progress)) {
                                progress.start(contentLength);
                            }
                            Throwable throwable3 = null;
                            Object var17_23 = null;
                            try (InputStream inputStream = entity.getContent();){
                                int bytesRead;
                                byte[] buffer = new byte[4096];
                                int totalBytesRead = 0;
                                while ((bytesRead = inputStream.read(buffer)) != -1) {
                                    os.write(buffer, 0, bytesRead);
                                    totalBytesRead += bytesRead;
                                    if (!Objects.nonNull(progress)) continue;
                                    progress.update((long)totalBytesRead);
                                }
                                if (Objects.nonNull(progress)) {
                                    progress.finish();
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new NetworkErrorException((Throwable)e);
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                throw new NetworkErrorException((Throwable)e1);
            }
        }
    }

    public com.kms.katalon.network.core.model.HttpResponse formPost(URI url, Map<String, String> body) throws HttpException {
        return this.formPost(url, body, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse formPost(URI url, Map<String, String> body, HttpOptions options) throws HttpException {
        HttpPost request = new HttpPost(url);
        request.setHeader("content-type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        List<BasicNameValuePair> pairs = body.entrySet().stream().map(item -> new BasicNameValuePair((String)item.getKey(), (String)item.getValue())).toList();
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse get(URI url) throws HttpException {
        return this.get(url, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse get(URI url, HttpOptions options) throws HttpException {
        HttpGet request = new HttpGet(url);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse jsonPost(URI url, String body) throws HttpException {
        return this.jsonPost(url, body, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse jsonPost(URI url, String body, HttpOptions options) throws HttpException {
        HttpPost request = new HttpPost(url);
        request.setHeader("content-type", ContentType.APPLICATION_JSON.getMimeType());
        StringEntity entity = null;
        try {
            entity = new StringEntity(body);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedContentException();
        }
        request.setEntity((HttpEntity)entity);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse post(URI url, HttpEntity entity) throws HttpException {
        return this.post(url, entity, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse post(URI url, HttpEntity entity, HttpOptions options) throws HttpException {
        HttpPost request = new HttpPost(url);
        request.setHeader("content-type", ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity(entity);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse jsonPut(URI url, String body, HttpOptions options) throws HttpException {
        HttpPut request = new HttpPut(url);
        request.setHeader("content-type", ContentType.APPLICATION_JSON.getMimeType());
        StringEntity entity = null;
        try {
            entity = new StringEntity(body);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedContentException();
        }
        request.setEntity((HttpEntity)entity);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse put(URI url, HttpEntity entity) throws HttpException {
        return this.put(url, entity, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse put(URI url, HttpEntity entity, HttpOptions options) throws HttpException {
        HttpPut request = new HttpPut(url);
        request.setEntity(entity);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    public com.kms.katalon.network.core.model.HttpResponse patch(URI url, HttpEntity entity) throws HttpException {
        return this.patch(url, entity, null);
    }

    public com.kms.katalon.network.core.model.HttpResponse patch(URI url, HttpEntity entity, HttpOptions options) throws HttpException {
        HttpPatch request = new HttpPatch(url);
        request.setHeader("content-type", ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity(entity);
        return this.sendRequest((HttpRequestBase)request, options);
    }

    /*
     * Exception decompiling
     */
    public com.kms.katalon.network.core.model.HttpResponse connect(String baseUrl, HttpOptions httpOptions) throws HttpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HttpResponse execute(HttpUriRequest request, HttpOptions options) throws IOException {
        Throwable throwable = null;
        Object var4_6 = null;
        try (CloseableHttpClient client = this.createHttpClient(request.getURI(), options);){
            HttpClientContext clientContext = options.getProxy() == null ? null : HttpProxyConfigurator.getInstance().createClientContextWithProxyAuth(options.getProxy(), request.getURI(), kerberosSupported);
            return client.execute(request, clientContext);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private CloseableHttpClient createHttpClient(URI requestUrl, HttpOptions options) {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        builder.setConnectionManagerShared(true);
        builder.setSSLContext(sc);
        builder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (options.getConnectTimeout() != null) {
            requestConfigBuilder.setConnectTimeout(options.getConnectTimeout().intValue());
        } else {
            requestConfigBuilder.setConnectTimeout(60000);
        }
        if (options.getSocketTimeout() != null) {
            requestConfigBuilder.setSocketTimeout(options.getSocketTimeout().intValue());
        }
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        builder.setKeepAliveStrategy((response, context) -> {
            BasicHeaderElementIterator headerIterator = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (headerIterator.hasNext()) {
                HeaderElement header = headerIterator.nextElement();
                String param = header.getName();
                String value = header.getValue();
                if (!param.equalsIgnoreCase("timeout") || value == null) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return 1L;
        });
        if (options != null) {
            HttpProxyConfigurator.getInstance().configureProxy(builder, options.getProxy(), sc, requestUrl);
        }
        return builder.build();
    }

    private com.kms.katalon.network.core.model.HttpResponse parseResponse(HttpResponse response) throws HttpException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            InputStream content = entity != null ? entity.getContent() : null;
            String body = entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) : "";
            HttpResponse.Builder responseBuilder = new HttpResponse.Builder();
            responseBuilder.setCapacity(response.getAllHeaders().length);
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                responseBuilder.addHeader(h.getName(), h.getValue());
                ++n2;
            }
            return responseBuilder.statusCode(statusCode).body(body).content(content).build();
        }
        catch (IOException iOException) {
            throw new MalformedContentException();
        }
    }

    /*
     * Exception decompiling
     */
    private com.kms.katalon.network.core.model.HttpResponse sendRequest(HttpRequestBase request, HttpOptions options) throws HttpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void applyHeaders(HttpRequestBase request, HttpOptions options) {
        Authentication authentication;
        request.setHeader("accept", "application/json");
        request.setHeader("sec-fetch-mode", "cors");
        request.setHeader("sec-fetch-dest", "empty");
        request.setHeader("sec-fetch-site", "same-site");
        if (options == null) {
            return;
        }
        Map headers = options.getHeaders();
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).setHeader(arg_0, arg_1));
        }
        if ((authentication = options.getAuthentication()) != null) {
            if (authentication instanceof BasicAuthentication) {
                BasicAuthentication basicAuth = (BasicAuthentication)authentication;
                String credentials = basicAuth.getUsername() + ":" + basicAuth.getPassword();
                String authString = Base64.getEncoder().encodeToString(credentials.getBytes());
                request.setHeader("Authorization", "Basic " + authString);
            } else if (authentication instanceof BearerAuthentication) {
                BearerAuthentication bearerAuth = (BearerAuthentication)authentication;
                String token = bearerAuth.getToken();
                request.setHeader("Authorization", "Bearer " + token);
            }
        }
    }
}

