/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.VariableSpec;
import com.github.fge.uritemplate.vars.VariableSpecType;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ExplodedVariable
extends VariableSpec {
    public ExplodedVariable(String name) {
        super(VariableSpecType.EXPLODED, name);
    }

    @Override
    protected String renderScalar(ExpressionType type, String value) throws URITemplateException {
        String s = ExplodedVariable.expandString(type, value);
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(ExplodedVariable.expandString(type, this.name));
        if (!s.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
            sb.append('=').append(s);
        }
        return sb.toString();
    }

    @Override
    protected String renderList(ExpressionType type, List<String> value) throws URITemplateException {
        Joiner joiner = Joiner.on((char)type.getSeparator());
        ArrayList list = Lists.newArrayList();
        for (String s : value) {
            list.add(ExplodedVariable.expandString(type, s));
        }
        if (!PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return joiner.join((Iterable)list);
        }
        ArrayList newList = Lists.newArrayList();
        String prefix = ExplodedVariable.expandString(type, this.name);
        for (String s : list) {
            StringBuilder sb = new StringBuilder(prefix);
            if (!s.isEmpty() || type != ExpressionType.PATH_PARAMETERS) {
                sb.append('=').append(s);
            }
            newList.add(sb.toString());
        }
        return joiner.join((Iterable)newList);
    }

    @Override
    protected String renderMap(ExpressionType type, Map<String, String> map) throws URITemplateException {
        if (map.isEmpty() && !PARAM_STYLE_EXPRESSIONS.contains((Object)type)) {
            return null;
        }
        Joiner joiner = Joiner.on((char)type.getSeparator());
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            StringBuilder sb = new StringBuilder(ExplodedVariable.expandString(type, entry.getKey())).append('=').append(ExplodedVariable.expandString(type, entry.getValue()));
            list.add(sb.toString());
        }
        return joiner.join((Iterable)list);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExplodedVariable other = (ExplodedVariable)obj;
        return this.name.equals(other.name);
    }

    @Override
    public String toString() {
        return this.name + " (exploded)";
    }
}

