/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.server;

import com.kms.katalon.ai.core.model.agent.event.McpClientAuthorizedEvent;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public class OAuthCallbackHandler
extends Handler.Abstract {
    @Inject
    private IEventBroker eventBroker;

    public boolean handle(Request request, Response response, Callback callback) {
        Fields params = Request.extractQueryParameters((Request)request);
        String state = this.extractQueryParameter("state", params);
        String authCode = this.extractQueryParameter("code", params);
        if (StringUtils.isNotBlank((CharSequence)authCode)) {
            McpClientAuthorizedEvent.post((String)state, (String)authCode, (IEventBroker)this.eventBroker);
            String message = "Authorized successfully.\r\nYou can close this page and return to Katalon Studio IDE.";
            String html = this.generateCallbackPage(message);
            Content.Sink.write((Content.Sink)response, (boolean)true, (String)html, (Callback)callback);
        } else {
            String reason = this.extractQueryParameter("error_description", params);
            if (StringUtils.isBlank((CharSequence)reason)) {
                reason = this.extractQueryParameter("error", params);
            }
            if (StringUtils.isBlank((CharSequence)reason)) {
                reason = "Unknown error";
            }
            String message = "Authorization failed.\r\nReason: " + reason;
            String html = this.generateCallbackPage(message);
            Content.Sink.write((Content.Sink)response, (boolean)true, (String)html, (Callback)callback);
        }
        return true;
    }

    private String extractQueryParameter(String name, Fields fields) {
        List values = fields.getValuesOrEmpty(name);
        return values.isEmpty() ? "" : (String)values.get(0);
    }

    private String generateCallbackPage(String message) {
        return "<body>\n    <style>\n    .auth-container {\n        position: fixed;\n        width: 100%;\n        height: 100%;\n        left: 0;\n        top: 0;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        flex-direction: column;\n        margin-top: -5%;\n    }\n    .auth-image {\n        width: 10rem;\n    }\n    .auth-message {\n        font-family: sans-serif;\n        font-size: 1.7rem;\n        white-space: pre-wrap;\n        text-align: center;\n        margin-top: 3rem;\n    }\n    </style>\n    <div class=\"auth-container\">\n        <div class=\"auth-message\">{message}</div>\n    </div>\n    <script>\n        window.close();\n        var url = new URL(location.href);\n        var simpleUrl = `${url.origin}${url.pathname}?context=AUTHORIZE`;\n        history.replaceState(null, \"\", simpleUrl);\n    </script>\n</body>\n".replace("{message}", message);
    }
}

