/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.logging.LogUtil;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class BddTools {
    @Inject
    private IEventBroker eventBroker;
    private static final String FEATURE_FOLDER_ROOT = "Include/features";
    private static final String FEATURE_FILE_EXTENSION = ".feature";

    public McpServerFeatures.SyncToolSpecification createBddFeatureFileTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createBddFeatureFile", "Create BDD Feature File", "Creates a new BDD feature file with Gherkin content in the current Katalon Studio project", this.createInputSchemaForCreateBddFeatureFileTool(), this.createOutputSchemaForCreateOrUpdateBddFeatureFileTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createBddFeatureFileToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createBddFeatureFileToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        String featureFileIdCreated = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String fileName = (String)arguments.get("fileName");
            String folderPath = (String)arguments.get("folderPath");
            String fileContent = (String)arguments.get("fileContent");
            if (StringUtils.isBlank((CharSequence)fileName)) {
                isError = true;
                resultContent = "fileName parameter is required";
            } else if (StringUtils.isBlank((CharSequence)fileContent)) {
                isError = true;
                resultContent = "fileContent parameter is required";
            } else {
                featureFileIdCreated = this.createBddFeatureFile(fileName.trim(), folderPath != null ? folderPath.trim() : null, fileContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating BDD feature file: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateOrUpdateBddFeatureFile(featureFileIdCreated);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private String createBddFeatureFile(String fileName, String folderPath, String fileContent) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        folderPath = StringUtils.isBlank((CharSequence)folderPath) ? FEATURE_FOLDER_ROOT : this.normalizeFeatureFolderPath(folderPath);
        if (!((String)fileName).toLowerCase().endsWith(FEATURE_FILE_EXTENSION)) {
            fileName = (String)fileName + FEATURE_FILE_EXTENSION;
        }
        SystemFileController systemFileController = SystemFileController.getInstance();
        FolderEntity targetFolder = this.getOrCreateFeatureFolder(project, folderPath);
        String fullFeatureFilePath = folderPath + "/" + (String)fileName;
        Path systemFilePath = Paths.get(project.getFolderLocation(), new String[0]).resolve(fullFeatureFilePath);
        if (Files.exists(systemFilePath, new LinkOption[0])) {
            throw new Exception("Feature file already exists: " + fullFeatureFilePath);
        }
        SystemFileEntity featureFile = systemFileController.newFile((String)fileName, fileContent, targetFolder);
        this.refreshFeatureFileInExplorer(featureFile);
        this.openFeatureFileInEditor(featureFile);
        return featureFile.getIdForDisplay();
    }

    public McpServerFeatures.SyncToolSpecification updateBddFeatureFileTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateBddFeatureFile", "Update BDD Feature File", "Updates an existing BDD feature file in the current Katalon Studio project", this.createInputSchemaForUpdateBddFeatureFileTool(), this.createOutputSchemaForCreateOrUpdateBddFeatureFileTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateBddFeatureFileToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateBddFeatureFileToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        String featureFileIdUpdated = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String featureFileId = (String)arguments.get("featureFileId");
            String fileContent = (String)arguments.get("fileContent");
            if (StringUtils.isBlank((CharSequence)featureFileId)) {
                isError = true;
                resultContent = "featureFileId parameter is required";
            } else {
                featureFileIdUpdated = this.updateBddFeatureFile(featureFileId.trim(), fileContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating BDD feature file: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateOrUpdateBddFeatureFile(featureFileIdUpdated);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private String updateBddFeatureFile(String featureFileId, String fileContent) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String projectRoot = project.getFolderLocation();
        String normalizedFeatureFileId = this.normalizeFeatureFolderPath(featureFileId);
        Path systemFilePath = Paths.get(projectRoot, new String[0]).resolve(normalizedFeatureFileId);
        if (!Files.exists(systemFilePath, new LinkOption[0])) {
            throw new Exception("Feature file not found at: " + normalizedFeatureFileId);
        }
        if (fileContent != null) {
            FileUtils.writeStringToFile((File)systemFilePath.toFile(), (String)fileContent, (Charset)StandardCharsets.UTF_8);
            GroovyRefreshUtil.refreshFile((String)normalizedFeatureFileId, (ProjectEntity)project);
        }
        return normalizedFeatureFileId;
    }

    private String normalizeFeatureFolderPath(String folderPath) {
        if (((String)(folderPath = ((String)folderPath).trim().replace("\\", "/"))).startsWith("/")) {
            folderPath = ((String)folderPath).substring(1);
        }
        if (((String)folderPath).endsWith("/")) {
            folderPath = ((String)folderPath).substring(0, ((String)folderPath).length() - 1);
        }
        if (!((String)folderPath).startsWith(FEATURE_FOLDER_ROOT) && !((String)folderPath).equals(FEATURE_FOLDER_ROOT)) {
            folderPath = ((String)folderPath).startsWith("features") ? "Include/" + (String)folderPath : "Include/features/" + (String)folderPath;
        }
        return folderPath;
    }

    private FolderEntity getOrCreateFeatureFolder(ProjectEntity project, String folderPath) throws Exception {
        FolderEntity folder = FolderController.getInstance().getFolderByDisplayId(project, folderPath);
        if (folder != null) {
            return folder;
        }
        File fullFolderPath = new File(project.getFolderLocation() + "/" + folderPath);
        if (!fullFolderPath.exists()) {
            fullFolderPath.mkdirs();
        }
        return FolderController.getInstance().getFolderByDisplayId(project, folderPath);
    }

    private void refreshFeatureFileInExplorer(SystemFileEntity featureFile) {
        try {
            SystemFileTreeEntity systemFileTreeEntity = TreeEntityUtil.getSystemFileTreeEntity((SystemFileEntity)featureFile, (FolderEntity)featureFile.getParentFolder());
            this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)systemFileTreeEntity);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)systemFileTreeEntity);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh feature file in explorer");
        }
    }

    private void closeEditorForFile(SystemFileEntity featureFile) {
        try {
            this.eventBroker.post("EDITORS_CLOSED", (Object)featureFile);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)("Failed to close editor for feature file: " + featureFile.getIdForDisplay()));
        }
    }

    private void openFeatureFileInEditor(SystemFileEntity featureFile) {
        try {
            SystemFileTreeEntity systemFileTreeEntity = TreeEntityUtil.getSystemFileTreeEntity((SystemFileEntity)featureFile, (FolderEntity)featureFile.getParentFolder());
            this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)systemFileTreeEntity.getObject());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to open feature file in editor");
        }
    }

    private Map<String, Object> createStructuredContentResultForCreateOrUpdateBddFeatureFile(String featureFileId) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("filePath", featureFileId != null ? featureFileId : "");
        return structuredContent;
    }

    private McpSchema.JsonSchema createInputSchemaForCreateBddFeatureFileTool() {
        Map<String, Map<String, String>> properties = Map.of("fileName", Map.of("type", "string", "description", "The name of the feature file to create (e.g., 'login.feature' or 'login'). Extension .feature will be added automatically if not present."), "folderPath", Map.of("type", "string", "description", "The folder path where the feature file should be created (e.g., 'Include/features' or 'Include/features/auth'). Optional, defaults to 'Include/features'."), "fileContent", Map.of("type", "string", "description", "The Gherkin content for the feature file, including Feature, Scenario, Given/When/Then steps"));
        return new McpSchema.JsonSchema("object", properties, List.of("fileName", "fileContent"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateBddFeatureFileTool() {
        Map<String, Map<String, String>> properties = Map.of("featureFileId", Map.of("type", "string", "description", "The ID of the feature file to update (e.g., 'Include/features/login.feature' or 'Include/features/login')"), "fileContent", Map.of("type", "string", "description", "The new Gherkin content for the feature file."));
        return new McpSchema.JsonSchema("object", properties, List.of("featureFileId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForCreateOrUpdateBddFeatureFileTool() {
        return Map.of("type", "object", "properties", Map.of("filePath", Map.of("type", "string", "description", "The path of the created/updated feature file")), "required", List.of("filePath"));
    }
}

