/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.ai.factory.AiAutoTagSettingFactory;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestCaseTools {
    @Inject
    private IEventBroker eventBroker;
    private static final String TEST_CASE_FOLDER_ROOT = "Test Cases";
    private static final String GEN_AI_TAG = "GenAI";
    private static final String STUDIOASSIST_ORIGIN = "STUDIOASSIST";

    public McpServerFeatures.SyncToolSpecification getTestCaseListTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestCases", "Get Test Case List", "Retrieves a list of all test case IDs available in the current Katalon Studio project", this.createEmptyInputSchema(), this.createOutputSchemaForGetTestCasesListTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestCaseListToolCallHandler()).build();
    }

    private McpSchema.CallToolResult getTestCaseListToolCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        List<Object> testCaseIDs = new ArrayList();
        try {
            testCaseIDs = this.getTestCaseList();
            resultContent = JsonUtil.toJson(testCaseIDs);
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test case list: " + e.getMessage();
        }
        Map structuredContent = Map.of("results", testCaseIDs);
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private List<String> getTestCaseList() throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        ArrayList<String> testCaseIds = new ArrayList<String>();
        FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(project);
        List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(testCaseRoot);
        if (descendantEntities == null || descendantEntities.isEmpty()) {
            return testCaseIds;
        }
        for (Object entity : descendantEntities) {
            if (!(entity instanceof TestCaseEntity)) continue;
            TestCaseEntity testCase = (TestCaseEntity)entity;
            testCaseIds.add(testCase.getIdForDisplay());
        }
        return testCaseIds;
    }

    public McpServerFeatures.SyncToolSpecification getTestCaseScriptTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestCaseScript", "Get Test Case Script", "Retrieves the Groovy script content and other metadata for a specific test case in current Katalon Studio project", this.createInputSchemaForGetTestCaseScriptTool(), this.createOutputSchemaForGetTestCaseScriptTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestCaseScriptToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult getTestCaseScriptToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        TestCaseEntity testCaseInfo = null;
        try {
            String testCaseId;
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if (StringUtils.isBlank((CharSequence)(testCaseId = (String)arguments.get("testCaseId")))) {
                isError = true;
                resultContent = "testCaseId parameter is required";
            } else {
                testCaseInfo = this.getTestCaseScript(testCaseId.trim());
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test case script: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForGetTestScriptTool(testCaseInfo);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestCaseEntity getTestCaseScript(String testCaseRelativeId) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String testCaseId = this.getTestCaseId(testCaseRelativeId);
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        if (testCase == null) {
            throw new Exception("Test case not found: " + testCaseRelativeId);
        }
        GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)testCase);
        return testCase;
    }

    private Map<String, Object> createStructuredContentResultForGetTestScriptTool(TestCaseEntity testCaseInfo) {
        String testCaseId = "";
        String testCaseName = "";
        String description = "";
        String comment = "";
        String tag = "";
        String scriptContent = "";
        if (testCaseInfo != null) {
            testCaseId = testCaseInfo.getIdForDisplay();
            testCaseName = testCaseInfo.getName();
            description = testCaseInfo.getDescription();
            comment = testCaseInfo.getComment();
            tag = testCaseInfo.getTag();
            if (testCaseInfo.getScriptContents() != null && testCaseInfo.getScriptContents().length > 0) {
                scriptContent = new String(testCaseInfo.getScriptContents(), StandardCharsets.UTF_8);
            }
        }
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testCaseId", testCaseId);
        structuredContent.put("testCaseName", testCaseName);
        structuredContent.put("description", description);
        structuredContent.put("comment", comment);
        structuredContent.put("tag", tag);
        structuredContent.put("scriptContent", scriptContent);
        return structuredContent;
    }

    public McpServerFeatures.SyncToolSpecification updateTestCaseScriptTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateTestCaseScript", "Update Test Case Script", "Updates the Groovy script content for an existing test case in current Katalon Studio project", this.createInputSchemaForUpdateTestCaseScriptTool(), this.createOutputSchemaForUpdateTestCaseScriptTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateTestCaseScriptToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateTestCaseScriptToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testCaseId = (String)arguments.get("testCaseId");
            String scriptContent = (String)arguments.get("scriptContent");
            if (StringUtils.isBlank((CharSequence)testCaseId)) {
                isError = true;
                resultContent = "testCaseId parameter is required";
            } else if (StringUtils.isBlank((CharSequence)scriptContent)) {
                isError = true;
                resultContent = "scriptContent parameter is required";
            } else {
                this.updateTestCaseScript(testCaseId.trim(), scriptContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating test case script: " + e.getMessage();
        }
        Map<String, Boolean> structuredContent = Map.of("success", !isError);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private void updateTestCaseScript(String testCaseRelativeId, String scriptContent) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String testCaseId = this.getTestCaseId(testCaseRelativeId);
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        if (testCase == null) {
            throw new Exception("Test case not found: " + testCaseRelativeId);
        }
        TestCaseController.getInstance().getOrCreateGroovyScriptForTestCase(testCase);
        File scriptFile = GroovyUtil.getTestCaseScriptFile((TestCaseEntity)testCase).getLocation().toFile();
        FileUtils.writeStringToFile((File)scriptFile, (String)scriptContent, (Charset)StandardCharsets.UTF_8);
        this.refreshTestScript(testCase, project);
    }

    public McpServerFeatures.SyncToolSpecification createNewTestCaseTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createTestCase", "Create Test Case", "Creates a new test case under a specific folder with the provided details in current Katalon Studio project", this.createInputSchemaForCreateTestCaseTool(), this.createOutputSchemaForCreateNewOrUpdateTestCaseTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createNewTestCaseToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createNewTestCaseToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        TestCaseEntity newTestCase = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testCaseName = (String)arguments.get("testCaseName");
            String folderPath = (String)arguments.get("folderPath");
            String tag = (String)arguments.get("tag");
            String description = (String)arguments.get("description");
            String comment = (String)arguments.get("comment");
            String scriptContent = (String)arguments.get("scriptContent");
            if (StringUtils.isBlank((CharSequence)testCaseName)) {
                isError = true;
                resultContent = "testCaseName parameter is required";
            } else {
                newTestCase = this.createNewTestCase(folderPath, testCaseName, tag, description, comment, scriptContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating test case: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestCase(newTestCase);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestCaseEntity createNewTestCase(String folderPath, String testCaseName, String tag, String description, String comment, String scriptContent) throws Exception {
        Object newTestCaseFolderPath;
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestCaseName(testCaseName);
        FolderEntity testCaseRootFolder = FolderController.getInstance().getTestCaseRoot(project);
        if (StringUtils.isNotEmpty((CharSequence)folderPath)) {
            folderPath = folderPath.trim().replace("\\", "/");
        }
        if (StringUtils.isNotBlank((CharSequence)folderPath) && (folderPath.equals(TEST_CASE_FOLDER_ROOT) || folderPath.startsWith("Test Cases/"))) {
            newTestCaseFolderPath = folderPath;
        } else {
            newTestCaseFolderPath = testCaseRootFolder.getIdForDisplay();
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                newTestCaseFolderPath = (String)newTestCaseFolderPath + "/" + folderPath;
            }
        }
        File fullNewTestCaseFolder = new File(project.getFolderLocation() + "/" + (String)newTestCaseFolderPath);
        if (!fullNewTestCaseFolder.exists()) {
            fullNewTestCaseFolder.mkdirs();
        }
        String fullTestCaseId = (String)newTestCaseFolderPath + "/" + testCaseName;
        TestCaseEntity existingTestCase = TestCaseController.getInstance().getTestCaseByDisplayId(fullTestCaseId);
        if (existingTestCase != null) {
            throw new Exception("Test case already exists: " + fullTestCaseId);
        }
        FolderEntity folderToCreateTestCase = FolderController.getInstance().getFolderByDisplayId(project, (String)newTestCaseFolderPath);
        TestCaseController testCaseController = TestCaseController.getInstance();
        TestCaseEntity testCase = testCaseController.newTestCaseWithoutSave(folderToCreateTestCase, testCaseName);
        this.setDataForTestCase(testCase, tag, description, comment);
        testCaseController.getOrCreateGroovyScriptForTestCase(testCase);
        if (StringUtils.isNotBlank((CharSequence)scriptContent)) {
            File scriptFile = GroovyUtil.getTestCaseScriptFile((TestCaseEntity)testCase).getLocation().toFile();
            FileUtils.writeStringToFile((File)scriptFile, (String)scriptContent, (Charset)StandardCharsets.UTF_8);
        }
        testCase.setOrigin(STUDIOASSIST_ORIGIN);
        TestCaseEntity savedTestCase = testCaseController.saveNewTestCase(testCase);
        this.refreshTestCaseInExplorer(savedTestCase);
        this.openTestCaseInEditor(savedTestCase);
        return savedTestCase;
    }

    public McpServerFeatures.SyncToolSpecification updateTestCaseTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateTestCase", "Update Test Case", "Updates test case including name, description, tags, comments in current Katalon Studio project", this.createUpdateTestCaseToolInputSchema(), this.createOutputSchemaForCreateNewOrUpdateTestCaseTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateTestCaseToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateTestCaseToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        TestCaseEntity updatedTestCase = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testCaseId = (String)arguments.get("testCaseId");
            String testCaseName = (String)arguments.get("testCaseName");
            String description = (String)arguments.get("description");
            String comment = (String)arguments.get("comment");
            String tag = (String)arguments.get("tag");
            if (StringUtils.isBlank((CharSequence)testCaseId)) {
                isError = true;
                resultContent = "testCaseId parameter is required";
            } else {
                updatedTestCase = this.updateTestCase(testCaseId.trim(), testCaseName, description, comment, tag);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating test case: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestCase(updatedTestCase);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestCaseEntity updateTestCase(String testCaseRelativeId, String testCaseName, String description, String comment, String tag) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String testCaseId = this.getTestCaseId(testCaseRelativeId);
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        if (testCase == null) {
            throw new Exception("Test case not found: " + testCaseRelativeId);
        }
        if (!StringUtils.isBlank((CharSequence)testCaseName) && !testCaseName.equals(testCase.getName())) {
            this.validateTestCaseName(testCaseName);
            String parentFolderId = testCase.getParentFolder().getIdForDisplay();
            String newTestCaseId = parentFolderId + "/" + testCaseName;
            TestCaseEntity existingTestCase = TestCaseController.getInstance().getTestCaseByDisplayId(newTestCaseId);
            if (existingTestCase != null && !existingTestCase.getId().equals(testCase.getId())) {
                throw new Exception("Test case with name '" + testCaseName + "' already exists in the same folder");
            }
            testCase = TestCaseController.getInstance().renameTestCase(testCase, testCaseName);
        }
        this.setDataForTestCase(testCase, tag, description, comment);
        TestCaseEntity updatedTestCase = TestCaseController.getInstance().updateTestCase(testCase);
        this.refreshTestCaseInExplorer(updatedTestCase);
        return updatedTestCase;
    }

    private Map<String, Object> createStructuredContentResultForCreateNewOrUpdateTestCase(TestCaseEntity testCase) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testCaseId", testCase != null ? testCase.getIdForDisplay() : "");
        return structuredContent;
    }

    private void setDataForTestCase(TestCaseEntity testCase, String tag, String description, String comment) throws Exception {
        String finalTag;
        if (description != null) {
            testCase.setDescription(description);
        }
        if (comment != null) {
            testCase.setComment(comment);
        }
        if ((finalTag = this.appendAiTags(tag)) != null) {
            testCase.setTag(finalTag);
        }
    }

    private void validateTestCaseName(String testCaseName) throws Exception {
        try {
            EntityService.getInstance().validateName(testCaseName);
        }
        catch (Exception exception) {
            throw new Exception("Invalid test case name");
        }
    }

    private void openTestCaseInEditor(TestCaseEntity testCaseEntity) {
        try {
            this.eventBroker.send("TESTCASE/OPEN", (Object)testCaseEntity);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to open test case in editor");
        }
    }

    private void refreshTestScript(TestCaseEntity testCaseEntity, ProjectEntity project) {
        try {
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
            IFolder testCaseScriptFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCaseEntity));
            testCaseScriptFolder.refreshLocal(2, null);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh test script");
        }
    }

    private Map<String, Object> createOutputSchemaForGetTestCasesListTool() {
        return Map.of("type", "object", "properties", Map.of("results", Map.of("type", "array", "items", Map.of("type", "string", "description", "Test Case ID"), "description", "List of test case IDs available in the project")), "required", List.of("results"));
    }

    private McpSchema.JsonSchema createInputSchemaForGetTestCaseScriptTool() {
        Map<String, Map<String, String>> properties = Map.of("testCaseId", Map.of("type", "string", "description", "The ID of the test case to retrieve"));
        return new McpSchema.JsonSchema("object", properties, List.of("testCaseId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForGetTestCaseScriptTool() {
        Map<String, Map<String, String>> properties = Map.of("testCaseId", Map.of("type", "string", "description", "The ID of the test case"), "testCaseName", Map.of("type", "string", "description", "The name of the test case"), "description", Map.of("type", "string", "description", "The description of the test case"), "comment", Map.of("type", "string", "description", "The comment for the test case"), "tag", Map.of("type", "string", "description", "The tag associated with the test case"), "scriptContent", Map.of("type", "string", "description", "The Groovy script content of the test case"));
        return Map.of("type", "object", "properties", properties, "required", List.of("testCaseId", "testCaseName", "description", "comment", "tag", "scriptContent"));
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateTestCaseScriptTool() {
        Map<String, Map<String, String>> properties = Map.of("testCaseId", Map.of("type", "string", "description", "The ID of the test case"), "scriptContent", Map.of("type", "string", "description", "The Groovy script content for the test case"));
        return new McpSchema.JsonSchema("object", properties, List.of("testCaseId", "scriptContent"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForUpdateTestCaseScriptTool() {
        return Map.of("type", "object", "properties", Map.of("success", Map.of("type", "boolean", "description", "Indicates if the update was successful")), "required", List.of("success"));
    }

    private McpSchema.JsonSchema createInputSchemaForCreateTestCaseTool() {
        Map<String, Map<String, String>> properties = Map.of("folderPath", Map.of("type", "string", "description", "The folder path where the test case should be created (e.g., 'Test Cases/Login', optional, defaults to root)"), "testCaseName", Map.of("type", "string", "description", "The name of the test case to create. Test Case Name must start with English letters or numbers, and can mix up with space or any of the following characters: ( ) . , _ -"), "tag", Map.of("type", "string", "description", "Tags for the test case (optional)"), "description", Map.of("type", "string", "description", "Description of the test case (optional)"), "comment", Map.of("type", "string", "description", "Comments for the test case (optional)"), "scriptContent", Map.of("type", "string", "description", "The Groovy script content for the test case (optional)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testCaseName"), null, null, null);
    }

    private McpSchema.JsonSchema createUpdateTestCaseToolInputSchema() {
        Map<String, Map<String, String>> properties = Map.of("testCaseId", Map.of("type", "string", "description", "The ID of the test case to update"), "testCaseName", Map.of("type", "string", "description", "New name for the test case (optional)"), "description", Map.of("type", "string", "description", "New description for the test case (optional, null to keep current)"), "comment", Map.of("type", "string", "description", "New comment for the test case (optional, null to keep current)"), "tag", Map.of("type", "string", "description", "New tags for the test case (optional, null to keep current)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testCaseId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForCreateNewOrUpdateTestCaseTool() {
        return Map.of("type", "object", "properties", Map.of("testCaseId", Map.of("type", "string", "description", "The ID of test case")), "required", List.of("testCaseId"));
    }

    private McpSchema.JsonSchema createEmptyInputSchema() {
        return new McpSchema.JsonSchema("object", Map.of(), List.of(), null, null, null);
    }

    private String getTestCaseId(String testCaseId) {
        if (!((String)(testCaseId = ((String)testCaseId).trim().replace("\\", "/"))).startsWith("Test Cases/")) {
            testCaseId = "Test Cases/" + (String)testCaseId;
        }
        return testCaseId;
    }

    private void refreshTestCaseInExplorer(TestCaseEntity testCaseEntity) {
        try {
            FolderTreeEntity folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)testCaseEntity.getParentFolder());
            this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)folderTreeEntity));
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh test case in explorer");
        }
    }

    private String appendAiTags(String existingTag) {
        Object finalTag = existingTag != null ? existingTag : "";
        IStudioAssistAiAutoTagSetting aiAutoTagSetting = this.getAiAutoTagSetting();
        if (aiAutoTagSetting == null) {
            return finalTag;
        }
        if (!aiAutoTagSetting.isCodeGeneration()) {
            return finalTag;
        }
        String aiTag = "";
        if (aiAutoTagSetting.isCodeGenerationCustomTag()) {
            aiTag = aiAutoTagSetting.getGenerateCodeCustomTag();
        } else if (aiAutoTagSetting.isCodeGenerationDefaultTag()) {
            aiTag = GEN_AI_TAG;
        }
        if (StringUtils.isBlank((CharSequence)aiTag)) {
            return finalTag;
        }
        if (StringUtils.isBlank((CharSequence)finalTag)) {
            return aiTag;
        }
        finalTag = (String)finalTag + "," + aiTag;
        return finalTag;
    }

    private IStudioAssistAiAutoTagSetting getAiAutoTagSetting() {
        try {
            AiAutoTagPolicyType policyType = ApplicationContext.getInstance().getAdministrationManagedKsSetting().getAiAutoTagging().getType();
            return AiAutoTagSettingFactory.getAiAutoTaggingSettingService(policyType);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to get AI auto tag setting");
            return null;
        }
    }
}

