/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.ai.mcp.tools.schema.CsvFileSchema;
import com.kms.katalon.ai.mcp.tools.schema.DatabaseDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.ExcelFileSchema;
import com.kms.katalon.ai.mcp.tools.schema.InternalDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.TestDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.TestDataSchemaFactory;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.logging.LogUtil;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestDataTools {
    @Inject
    private IEventBroker eventBroker;
    private static final String TEST_DATA_FOLDER_ROOT = "Data Files";

    public McpServerFeatures.SyncToolSpecification getTestDataListTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestDataList", "Get Test Data List", "Retrieves a list of all test data entities available in the current Katalon Studio project", this.createEmptyInputSchema(), this.createOutputSchemaForGetTestDataListTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestDataListToolCallHandler()).build();
    }

    private McpSchema.CallToolResult getTestDataListToolCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        List<Object> testDataList = new ArrayList();
        try {
            testDataList = this.getTestDataList();
            resultContent = JsonUtil.toJson(testDataList);
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test data list: " + e.getMessage();
        }
        Map structuredContent = Map.of("results", testDataList);
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    public List<Map<String, Object>> getTestDataList() throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        ArrayList<Map<String, Object>> testDataInfos = new ArrayList<Map<String, Object>>();
        FolderEntity testDataRoot = FolderController.getInstance().getTestDataRoot(project);
        List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(testDataRoot);
        if (descendantEntities == null || descendantEntities.isEmpty()) {
            return testDataInfos;
        }
        for (Object entity : descendantEntities) {
            if (!(entity instanceof DataFileEntity)) continue;
            DataFileEntity testData = (DataFileEntity)entity;
            TestDataSchema schema = this.createTestDataSchema(testData);
            testDataInfos.add(schema.toDataMap());
        }
        return testDataInfos;
    }

    private TestDataSchema createTestDataSchema(DataFileEntity testData) {
        String testDataId = testData.getIdForDisplay();
        String testDataName = testData.getName();
        String description = testData.getDescription();
        String location = testData.getLocation();
        switch (testData.getDriver()) {
            case InternalData: {
                ArrayList<String> columnNames = new ArrayList<String>();
                for (InternalDataColumnEntity column : testData.getInternalDataColumns()) {
                    columnNames.add(column.getName());
                }
                return new InternalDataSchema(testDataId, testDataName, description, location, columnNames);
            }
            case ExcelFile: {
                return new ExcelFileSchema(testDataId, testDataName, description, location, testData.getDataSourceUrl(), testData.isContainsHeaders(), testData.getSheetName());
            }
            case CSV: {
                return new CsvFileSchema(testDataId, testDataName, description, location, testData.getDataSourceUrl(), testData.isContainsHeaders(), testData.getCsvSeperator());
            }
            case DBData: {
                return new DatabaseDataSchema(testDataId, testDataName, description, location, testData.getQuery());
            }
        }
        throw new IllegalArgumentException("Unknown driver type: " + String.valueOf(testData.getDriver()));
    }

    public McpServerFeatures.SyncToolSpecification createInternalTestDataTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createInternalTestData", "Create Internal Test Data", "Creates a new internal test data entity with specified data in the current Katalon Studio project", this.createInputSchemaForCreateInternalTestDataTool(), this.createOutputSchemaForCreateInternalTestDataTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createInternalTestDataToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createInternalTestDataToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        DataFileEntity newTestData = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testDataName = (String)arguments.get("testDataName");
            String description = (String)arguments.get("description");
            String folderPath = (String)arguments.get("folderPath");
            List dataTable = (List)arguments.get("dataTable");
            if (StringUtils.isBlank((CharSequence)testDataName)) {
                isError = true;
                resultContent = "testDataName parameter is required";
            } else if (dataTable == null || dataTable.isEmpty()) {
                isError = true;
                resultContent = "dataTable parameter is required";
            } else {
                newTestData = this.createInternalTestData(testDataName, description, folderPath, dataTable);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating internal test data: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateInternalTestDataTool(newTestData);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private DataFileEntity createInternalTestData(String testDataName, String description, String folderPath, List<Map<String, Object>> dataTable) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestDataName(testDataName);
        String projectRoot = project.getFolderLocation();
        Object newTestDataFolderPath = "";
        FolderEntity testDataRootFolder = FolderController.getInstance().getTestDataRoot(project);
        if (StringUtils.isNotBlank((CharSequence)folderPath) && (folderPath.equals(TEST_DATA_FOLDER_ROOT) || folderPath.startsWith("Data Files/"))) {
            newTestDataFolderPath = folderPath;
        } else {
            newTestDataFolderPath = testDataRootFolder.getIdForDisplay();
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                newTestDataFolderPath = (String)newTestDataFolderPath + "/" + folderPath;
            }
        }
        Path testDataFilePath = Paths.get(projectRoot, new String[]{newTestDataFolderPath});
        if (!Files.exists(testDataFilePath, new LinkOption[0])) {
            Files.createDirectories(testDataFilePath, new FileAttribute[0]);
        }
        FolderEntity folderToCreateTestData = FolderController.getInstance().getFolderByDisplayId(project, (String)newTestDataFolderPath);
        TestDataController testDataController = TestDataController.getInstance();
        List existingTestDataList = testDataController.getDataFileFromParentFolder(folderToCreateTestData);
        if (existingTestDataList != null) {
            for (DataFileEntity existingTestData : existingTestDataList) {
                if (!existingTestData.getName().equals(testDataName.trim())) continue;
                throw new Exception("Test data with name '" + testDataName.trim() + "' already exists in folder '" + (String)newTestDataFolderPath + "'");
            }
        }
        DataFileEntity newTestData = testDataController.newTestDataWithoutSave(folderToCreateTestData, testDataName.trim());
        newTestData.setDriver(DataFileEntity.DataFileDriverType.InternalData);
        newTestData.setDescription(description != null ? description.trim() : "");
        List<Map<String, Object>> dataRows = dataTable;
        Map<String, Object> firstRow = dataRows.get(0);
        ArrayList<String> columnNames = new ArrayList<String>(firstRow.keySet());
        ArrayList<InternalDataColumnEntity> internalDataColumns = new ArrayList<InternalDataColumnEntity>();
        int i = 0;
        while (i < columnNames.size()) {
            String columnName = (String)columnNames.get(i);
            InternalDataColumnEntity column = new InternalDataColumnEntity();
            column.setName(columnName);
            column.setColumnIndex(i);
            column.setSize(dataRows.size());
            internalDataColumns.add(column);
            ++i;
        }
        newTestData.setInternalDataColumns(internalDataColumns);
        ArrayList rowsData = new ArrayList();
        int rowIndex = 0;
        while (rowIndex < dataRows.size()) {
            Map<String, Object> row = dataRows.get(rowIndex);
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (String columnName : columnNames) {
                Object value = row.get(columnName);
                value = value == null || value.toString().trim().equals("") ? "null" : value.toString();
                rowData.add(value);
            }
            rowsData.add(rowData);
            ++rowIndex;
        }
        newTestData.setData(rowsData);
        newTestData.setEncriptData(rowsData);
        newTestData.setContainsHeaders(true);
        DataFileEntity newTestDataCreated = testDataController.saveNewTestData(newTestData);
        this.refreshTestDataInExplorer(newTestDataCreated);
        this.openTestDataInEditor(newTestDataCreated);
        return newTestDataCreated;
    }

    private Map<String, Object> createStructuredContentResultForCreateInternalTestDataTool(DataFileEntity testData) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testDataId", testData != null ? testData.getIdForDisplay() : "");
        return structuredContent;
    }

    private void refreshTestDataInExplorer(DataFileEntity dataFile) {
        try {
            FolderTreeEntity parentTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)dataFile.getParentFolder());
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestDataTreeEntity(dataFile, (ITreeEntity)parentTreeEntity));
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh test data in explorer");
        }
    }

    private void openTestDataInEditor(DataFileEntity dataFile) {
        try {
            this.eventBroker.post("TESTDATA/OPEN", (Object)dataFile);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to open test data in editor");
        }
    }

    private void validateTestDataName(String testDataName) throws Exception {
        try {
            EntityService.getInstance().validateName(testDataName);
        }
        catch (Exception exception) {
            throw new Exception("Invalid test data name");
        }
    }

    private McpSchema.JsonSchema createEmptyInputSchema() {
        return new McpSchema.JsonSchema("object", Map.of(), List.of(), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForCreateInternalTestDataTool() {
        Map<String, Map<String, Map<String, Map<String, String>>>> properties = Map.of("testDataName", Map.of("type", "string", "description", "Name of the test data entity to create (required). Test Data Name must start with English letters or numbers, and can mix up with space or any of the following characters: ( ) . , _ -"), "description", Map.of("type", "string", "description", "Description of the test data entity (optional)"), "folderPath", Map.of("type", "string", "description", "Path to the folder where the test data should be created (optional, defaults to test data root, e.g., 'Data Files/LoginData')"), "dataTable", Map.of("type", "array", "description", "New test data table represented as an array of rows, where each row is a map of column names to values (required). e.g., [{\"username\": \"user1\", \"password\": \"pass1\"}, {\"username\": \"user2\", \"password\": \"pass2\"}]", "items", Map.of("type", "object", "description", "An object representing a single row of data. Each key is a column name and the value is the cell value.", "additionalProperties", Map.of("type", "string", "description", "Cell value as a string"))));
        return new McpSchema.JsonSchema("object", properties, List.of("testDataName", "dataTable"), null, null, null);
    }

    public Map<String, Object> createOutputSchemaForGetTestDataListTool() {
        return Map.of("type", "object", "properties", Map.of("results", Map.of("type", "array", "description", "List of test data entities in the current Katalon Studio project", "items", TestDataSchemaFactory.createTestDataItemsSchema())), "required", List.of("results"));
    }

    public Map<String, Object> createOutputSchemaForCreateInternalTestDataTool() {
        return Map.of("type", "object", "properties", Map.of("testDataId", Map.of("type", "string", "description", "The ID of the newly created test data entity for display (e.g., 'Data Files/LoginData')")), "required", List.of("testDataId"));
    }
}

