/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class GeminiPreferenceStore
extends StudioAssistPreferenceStore {
    public static final String GEMINI_BASE_URL = "gemini_base_url";
    public static final String GEMINI_API_KEY = "gemini_api_key";
    public static final String GEMINI_API_MODEL = "gemini_model";
    public static final String GEMINI_MAX_TOKEN = "gemini_max_token";
    public static final String GEMINI_API_VERSION = "gemini_api_version";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String baseUrl = this.decode(this.store.getString(GEMINI_BASE_URL));
            String apiKey = this.decode(this.store.getString(GEMINI_API_KEY));
            String model = this.decode(this.store.getString(GEMINI_API_MODEL));
            int maxToken = this.store.getInt(GEMINI_MAX_TOKEN);
            return new GeminiConfig(baseUrl, apiKey, model, maxToken);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        this.store.setValue(STUDIO_ASSIST_CONFIG_TYPE, StudioAssistConfigType.GEMINI.toString());
        try {
            String baseUrl = ((GeminiConfig)credential).getBaseUrl();
            this.store.setValue(GEMINI_BASE_URL, this.encode(baseUrl));
            String apiKey = ((GeminiConfig)credential).getApiKey();
            this.store.setValue(GEMINI_API_KEY, this.encode(apiKey));
            String model = ((GeminiConfig)credential).getModel();
            this.store.setValue(GEMINI_API_MODEL, this.encode(model));
            this.store.setValue(GEMINI_MAX_TOKEN, ((GeminiConfig)credential).getMaxToken());
            this.store.save();
        }
        catch (Exception e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

