/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.session.core.model.ManagedOpenAiConfig;
import java.util.Objects;
import java.util.Optional;

public class ManagedOpenAiPreferenceStore
extends StudioAssistPreferenceStore {
    public static String ADMIN_OPENAI_MAX_TOKEN = "admin_openai_max_token";
    public static String ADMIN_OPENAI_MODEL_NAME = "admin_openai_model_name";
    private ApplicationContext applicationContext;

    public ManagedOpenAiPreferenceStore(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String modelName;
            ManagedOpenAiConfig adminOpenAiConfig = (ManagedOpenAiConfig)this.applicationContext.getAiConfigPolicy().getManagedOpenAi().orElseThrow(() -> new IllegalStateException("ManagedOpenAiConfig is not available"));
            String secretKey = adminOpenAiConfig.getApiKey();
            int maxToken = this.store.getInt(ADMIN_OPENAI_MAX_TOKEN);
            if (maxToken < 1) {
                maxToken = 16000;
            }
            if (Objects.nonNull(modelName = this.store.getString(ADMIN_OPENAI_MODEL_NAME)) && modelName.isBlank()) {
                modelName = OpenAIConfig.DEFAULT_MODEL;
            }
            String organization = Optional.ofNullable(adminOpenAiConfig.getOrganizationId()).orElse(null);
            return new OpenAIConfig(secretKey, maxToken, organization, modelName);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to get config in ManagedOpenAIPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        try {
            this.store.setValue(ADMIN_OPENAI_MAX_TOKEN, ((OpenAIConfig)credential).getMaxToken());
            this.store.setValue(ADMIN_OPENAI_MODEL_NAME, ((OpenAIConfig)credential).getModelName());
            this.store.save();
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedOpenAIPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

