/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.services.BaseOpenAiService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.InvalidRequestException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

public class OpenAiCompatibleService
extends BaseOpenAiService {
    private OpenAiCompatibleConfig config;

    public OpenAiCompatibleService(OpenAiCompatibleConfig config) {
        this.config = config;
        this.model = config.getModelName();
    }

    @Override
    protected BaseOpenAiService.ChatCompletionsData sendRequest(ChatCompletionsOptions completionsOptions) throws URISyntaxException, HttpException {
        URI baseUri = new URI(this.config.getBaseUrl());
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/chat/completions").build();
        HashMap<String, String> headers = new HashMap<String, String>();
        String apiKey = this.config.getApiKey();
        String apiKeyHeaderName = this.config.getApiKeyHeaderName();
        BearerAuthentication authentication = null;
        if (StringUtils.isNotBlank((CharSequence)apiKey)) {
            if ("Authorization".equals(this.config.getApiKeyHeaderName()) || StringUtils.isBlank((CharSequence)apiKeyHeaderName)) {
                authentication = new BearerAuthentication(apiKey);
            } else {
                headers.put(apiKeyHeaderName, apiKey);
            }
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        try {
            StringEntity entity = new StringEntity(completionsOptions.toJsonString());
            HttpResponse response = this.httpClient.post(uri, (HttpEntity)entity, httpOptions);
            return new BaseOpenAiService.ChatCompletionsData(uri, httpOptions, response);
        }
        catch (IOException e) {
            throw new InvalidRequestException((Throwable)e);
        }
    }
}

