/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.constants.GenAiChatJobStatus;
import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContext;
import com.kms.katalon.ai.core.model.chat.StudioAssistUploadedFileHistory;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAiSettingDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.util.ToolUtil;
import com.kms.katalon.ai.internal.IGenAiClient;
import com.kms.katalon.ai.internal.IGenAiClientFactory;
import com.kms.katalon.ai.internal.model.AskForUploadFileRequest;
import com.kms.katalon.ai.internal.model.AskForUploadFileResponse;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerError;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerRequest;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerResponse;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionRequest;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionResponse;
import com.kms.katalon.ai.internal.model.UploadFileRequest;
import com.kms.katalon.ai.internal.model.UploadFileResponse;
import com.kms.katalon.ai.services.genai.dto.GenAiChatAttachment;
import com.kms.katalon.ai.services.genai.dto.GenAiChatMessage;
import com.kms.katalon.ai.services.genai.dto.GenAiChatMessageRequest;
import com.kms.katalon.ai.services.genai.dto.GenAiChatTool;
import com.kms.katalon.ai.services.internal.UploadAttachmentCallable;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.services.ISessionManager;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StudioAssistChatAnswerGenAiClientFuture
extends StudioAssistChatAnswerMessageFuture {
    private static final int FUTURE_MAX_WAITING_TIME = 60;
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatAnswerGenAiClientFuture.class);
    @Inject
    IGenAiClientFactory clientFactory;
    @Inject
    private ISessionManager sessionManager;
    private ExecutorService executorService;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;
    private int intervalFetchInMs;
    private int maxFetchingTimes;
    private List<StudioAssistChatItem> conversation;
    private List<GenAiChatAttachment> genAiAttachments;
    private ChatMode chatMode = ChatMode.ASK;

    public StudioAssistChatAnswerGenAiClientFuture(ExecutorService executorService, ChatMode chatMode, List<StudioAssistChatItem> conversation, StudioAssistChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools, int intervalFetchInMs, int maxFetchingTimes) {
        super(null, question, availableTools);
        this.chatMode = chatMode;
        this.conversation = conversation;
        this.executorService = executorService;
        this.intervalFetchInMs = intervalFetchInMs;
        this.maxFetchingTimes = maxFetchingTimes;
    }

    public void run() {
        super.run();
        long startTime = System.currentTimeMillis();
        try {
            try {
                int fetchingTimes;
                String chatJobId;
                IGenAiClient client = this.clientFactory.createGenAiClient();
                Long accountId = Optional.ofNullable(this.sessionManager.getAccount()).map(Account::getId).orElse(null);
                Long orgId = Optional.ofNullable(this.sessionManager.getOrganization()).map(Organization::getId).orElse(null);
                Long userId = Optional.ofNullable(this.sessionManager.getUser()).map(User::getId).orElse(null);
                this.validate(orgId, accountId, userId);
                GenAiSubmitQuestionResponse questionResponse = null;
                if (!this.isCancelled()) {
                    List<GenAiChatMessage> messages = this.buildChatMessage(accountId, orgId, userId);
                    List<GenAiChatTool> availableTools = this.getLlmTools().stream().map(tool -> {
                        GenAiChatTool chatTool = new GenAiChatTool();
                        chatTool.setName(tool.name());
                        chatTool.setDescription(tool.description());
                        ObjectMapper objectMapper = new ObjectMapper();
                        try {
                            String json = objectMapper.writeValueAsString((Object)tool.inputSchema());
                            Map toolSchema = (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
                            chatTool.setParameters(toolSchema);
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            return null;
                        }
                        return chatTool;
                    }).filter(Objects::nonNull).toList();
                    GenAiSubmitQuestionRequest request = new GenAiSubmitQuestionRequest(orgId, accountId, userId, messages);
                    request.setAvailableTools(availableTools);
                    request.setChatMode(this.chatMode.name());
                    questionResponse = client.submitQuestion(request);
                }
                if ((chatJobId = (String)Optional.ofNullable(questionResponse).map(GenAiSubmitQuestionResponse::getChatJobId).orElse(null)) == null) {
                    this.logger.error("Received null as chat job id when submit question");
                    throw new StudioAssistLlmApiRuntimeException("Received null as chat job id when submit question");
                }
                GenAiGetAnswerRequest genAiGetAnswerRequest = new GenAiGetAnswerRequest(orgId, accountId, userId, chatJobId);
                for (fetchingTimes = 1; !this.isCancelled() && fetchingTimes <= this.maxFetchingTimes; ++fetchingTimes) {
                    this.logger.debug("Fetching %s times | chatJobId = %s".formatted(fetchingTimes, chatJobId));
                    GenAiGetAnswerResponse answerResponse = client.getAnswer(genAiGetAnswerRequest);
                    if (answerResponse != null) {
                        if (GenAiChatJobStatus.CANCELLED == answerResponse.getStatus()) {
                            this.logger.debug("Chat job has been cancelled | chatJobId = %s".formatted(answerResponse.getChatJobId()));
                            break;
                        }
                        if (GenAiChatJobStatus.COMPLETED == answerResponse.getStatus()) {
                            this.handleCompletedResponse(answerResponse);
                            break;
                        }
                    } else {
                        this.logger.debug("answerResponse is null, jump to next fetch");
                    }
                    try {
                        StudioAssistChatAnswerGenAiClientFuture.sleep((long)this.intervalFetchInMs);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (this.maxFetchingTimes < fetchingTimes) {
                    this.logger.debug("Exceeded max fetching time, stop the fetching | chatJobId = %s".formatted(chatJobId));
                    throw new StudioAssistLlmApiServerTimeoutException("LLM takes too long to provide the answer");
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                this.logger.error("Known exception while handle Katalon AI chat question", (Throwable)ex);
                throw new StudioAssistLlmApiClientException((Throwable)ex);
            }
            catch (StudioAssistLlmApiNoInternetException e) {
                this.logger.error("Internet disconnected while handle Katalon AI chat question", (Throwable)e);
                throw new StudioAssistLlmApiNoInternetException((Throwable)e);
            }
            catch (StudioAssistLlmApiResourceExhaustedException e) {
                this.logger.error("Resource exhausted while handle Katalon AI chat question", (Throwable)e);
                throw new StudioAssistLlmApiResourceExhaustedException(e.getMessage());
            }
            catch (Exception e) {
                this.logger.error("Exception while handle Katalon AI chat question", (Throwable)e);
                throw new StudioAssistLlmApiClientException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.logger.debug("Fetching chat answer from Katalon AI completed | processingTime = %s".formatted(System.currentTimeMillis() - startTime));
            throw throwable;
        }
        this.logger.debug("Fetching chat answer from Katalon AI completed | processingTime = %s".formatted(System.currentTimeMillis() - startTime));
    }

    private void handleCompletedResponse(GenAiGetAnswerResponse answerResponse) {
        GenAiGetAnswerError finishError = answerResponse.getFinishError();
        if (finishError != null) {
            int errorCode = finishError.getCode();
            String errorMessage = finishError.getMessage();
            switch (errorCode) {
                case 3: {
                    if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"Content violated filtered")) {
                        throw new StudioAssistLlmApiServerContentViolatedException(errorMessage);
                    }
                    throw new StudioAssistLlmApiClientException(errorMessage);
                }
                case 7: {
                    throw new StudioAssistLlmApiAiSettingDisabledException(errorMessage);
                }
                case 16: {
                    throw new StudioAssistLlmApiAuthenticationException(errorMessage);
                }
                case 11: {
                    if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"Token limit reached")) {
                        throw new StudioAssistLlmApiServerTokenExceededException(errorMessage);
                    }
                    throw new StudioAssistLlmApiRuntimeException(errorMessage);
                }
                case 8: {
                    throw new StudioAssistLlmApiResourceExhaustedException();
                }
            }
            throw new StudioAssistLlmApiRuntimeException(errorMessage);
        }
        if (this.isTheAnswerNull(answerResponse) || this.isEmptyAnswer(answerResponse)) {
            throw new StudioAssistLlmApiServerNoAnswerException("Empty answer from Katalon AI LLM");
        }
        if (CollectionUtils.isEmpty((Collection)answerResponse.getAnswer().getToolCalls())) {
            StudioAssistChatAnswerMessage chatAnswerMsg = answerResponse.getAnswer();
            chatAnswerMsg.setMessageId(this.getMessageId());
            chatAnswerMsg.setUploadedFileMap(Optional.ofNullable(this.genAiAttachments).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(GenAiChatAttachment::getFileClientId, item -> new StudioAssistUploadedFileHistory(item.getFileClientId(), item.getFileId()))));
            this.setResult((ResponseMessage)chatAnswerMsg);
            return;
        }
        List<ResponseMessage> toolCalls = answerResponse.getAnswer().getToolCalls().stream().map(item -> {
            String toolName;
            String server = ToolUtil.parseServerNameFromToolCall((String)item.getName());
            McpSchema.Tool tool = this.getToolFromServerNameAndToolName(server, toolName = ToolUtil.parseToolNameFromToolCall((String)item.getName()));
            if (tool == null) {
                this.logger.debug("Tool not found for tool call name: {} ", (Object)item.getName());
                return null;
            }
            ToolCallMessage toolCall = new ToolCallMessage(tool);
            toolCall.setServer(server);
            toolCall.setCallId(item.getCallId());
            toolCall.setInput(item.getInput());
            toolCall.setOutput(item.getOutput());
            return toolCall;
        }).filter(Objects::nonNull).map(toolCallMessage -> toolCallMessage).toList();
        AgentMessage agentMessage = new AgentMessage(this.getMessageId(), this.getConversationId());
        agentMessage.setChildren(toolCalls);
        this.setResult((ResponseMessage)agentMessage);
    }

    private boolean isEmptyAnswer(GenAiGetAnswerResponse answerResponse) {
        return StringUtils.isBlank((CharSequence)answerResponse.getAnswer().getFinalAnswer()) && answerResponse.getAnswer().getWarning() == null && answerResponse.getAnswer().getSuggestedQuestions() == null && CollectionUtils.isEmpty((Collection)answerResponse.getAnswer().getToolCalls());
    }

    private boolean isTheAnswerNull(GenAiGetAnswerResponse answerResponse) {
        return answerResponse.getAnswer() == null;
    }

    private List<GenAiChatMessage> buildChatMessage(Long accountId, Long orgId, Long userId) throws InterruptedException, ExecutionException, TimeoutException {
        StudioAssistChatQuestionMessage question = this.question;
        ArrayList chatItems = this.conversation.stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).collect(Collectors.toCollection(ArrayList::new));
        if (question == null && !chatItems.isEmpty()) {
            StudioAssistChatPair lastChatPair = (StudioAssistChatPair)chatItems.remove(chatItems.size() - 1);
            question = lastChatPair.getQuestion();
        }
        if (question != null && StringUtils.isNotEmpty((CharSequence)question.getQuestionContent())) {
            List oldAttachments = chatItems.stream().flatMap(item -> item.getQuestion().getAttachments().stream()).toList();
            List<StudioAssistChatAttachment> newAttachments = question.getAttachments().stream().filter(newAttachment -> oldAttachments.stream().noneMatch(oldAttachment -> StringUtils.equals((CharSequence)newAttachment.getFileClientId(), (CharSequence)oldAttachment.getFileClientId()))).filter(attachment -> StringUtils.isEmpty((CharSequence)attachment.getFileId())).toList();
            this.genAiAttachments = this.handleUploadAttachments(accountId, orgId, userId, newAttachments);
        }
        ArrayList messages = this.conversation.stream().map(this::mapObjectToGenAiChatMessages).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        if (this.question != null && question != null) {
            if (this.chatMode == ChatMode.ASK && this.genAiAttachments.isEmpty()) {
                this.genAiAttachments = question.getAttachments().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFileClientId()) && StringUtils.isNotBlank((CharSequence)item.getFileId())).map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
            }
            messages.add(new GenAiChatMessage(new GenAiChatMessageRequest(question.getQuestionContent(), this.genAiAttachments), null));
        }
        return messages;
    }

    private List<GenAiChatAttachment> handleUploadAttachments(Long accountId, Long orgId, Long userId, List<StudioAssistChatAttachment> attachments) throws InterruptedException, ExecutionException, TimeoutException {
        if (attachments.isEmpty()) {
            return List.of();
        }
        Map uploadFileRequestMap = attachments.stream().map(item -> new UploadFileRequest(item.getFileClientId(), item.buildMetadata(), ContentType.TEXT_PLAIN.getMimeType())).collect(Collectors.toMap(UploadFileRequest::getFileClientId, Function.identity()));
        IGenAiClient client = this.clientFactory.createGenAiClient();
        AskForUploadFileResponse response = client.askForUploadFiles(new AskForUploadFileRequest(orgId, accountId, userId, new ArrayList<UploadFileRequest>(uploadFileRequestMap.values())));
        List<UploadFileResponse> objects = response.getObjects();
        if (objects == null || objects.isEmpty()) {
            this.logger.warn("Received empty AskForUploadFileResponse");
            return List.of();
        }
        Map attachmentsMap = attachments.stream().collect(Collectors.toMap(StudioAssistChatAttachment::getFileClientId, Function.identity()));
        List<UploadAttachmentCallable> callables = objects.stream().map(item -> new UploadAttachmentCallable((StudioAssistChatAttachment)attachmentsMap.get(item.getFileClientId()), (UploadFileRequest)uploadFileRequestMap.get(item.getFileClientId()), (UploadFileResponse)item, this.httpClient, this.networkPreferences)).toList();
        List futures = this.executorService.invokeAll(callables);
        HashMap<String, UploadFileResponse> uploadFileResponseMap = new HashMap<String, UploadFileResponse>(attachments.size());
        for (Future future : futures) {
            UploadFileResponse futureResponse = (UploadFileResponse)future.get(60L, TimeUnit.SECONDS);
            uploadFileResponseMap.put(futureResponse.getFileClientId(), futureResponse);
        }
        attachments.forEach(item -> {
            String fileClientId = item.getFileClientId();
            UploadFileResponse uploadFileResponse = (UploadFileResponse)uploadFileResponseMap.get(fileClientId);
            if (uploadFileResponse != null) {
                item.setFileId(uploadFileResponse.getFileId());
            }
        });
        return attachments.stream().map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
    }

    private void validate(Long orgId, Long accountId, Long userId) {
        if (orgId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get Organization Id");
        }
        if (accountId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get Account Id");
        }
        if (userId == null) {
            throw new StudioAssistLlmApiRuntimeException("Cannot get User Id");
        }
    }

    private List<GenAiChatMessage> mapObjectToGenAiChatMessages(Object message) {
        if (message instanceof StudioAssistChatPair) {
            StudioAssistChatPair chatPair = (StudioAssistChatPair)message;
            return this.mapToGenAiChatMessages(chatPair);
        }
        if (message instanceof StudioAssistChatReferenceContext) {
            StudioAssistChatReferenceContext context = (StudioAssistChatReferenceContext)message;
            return this.mapToGenAiChatMessages(context);
        }
        throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
    }

    private List<GenAiChatMessage> mapToGenAiChatMessages(StudioAssistChatPair chatPair) {
        List<GenAiChatAttachment> chatAttachments = chatPair.getQuestion().getAttachments().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFileClientId()) && StringUtils.isNotBlank((CharSequence)item.getFileId())).map(item -> new GenAiChatAttachment(item.getFileClientId(), item.getFileId())).toList();
        GenAiChatMessage chatRequest = GenAiChatMessage.request(chatPair.getQuestion().getQuestionContent(), chatAttachments);
        GenAiChatMessage chatResponse = null;
        ResponseMessage responseMessage = chatPair.getResponse();
        if (responseMessage instanceof StudioAssistChatAnswerMessage) {
            StudioAssistChatAnswerMessage finalAnswer = (StudioAssistChatAnswerMessage)responseMessage;
            chatResponse = GenAiChatMessage.response(finalAnswer.getFinalAnswer());
        } else {
            ResponseMessage responseMessage2 = chatPair.getResponse();
            if (responseMessage2 instanceof AgentMessage) {
                AgentMessage agentMessage = (AgentMessage)responseMessage2;
                String finalAnswer = agentMessage.getChildren().stream().filter(child -> child instanceof StudioAssistChatAnswerMessage).findFirst().map(child -> (StudioAssistChatAnswerMessage)child).map(StudioAssistChatAnswerMessage::getFinalAnswer).orElse("");
                List<ToolCall> toolCalls = agentMessage.getChildren().stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child).map(toolCall -> {
                    ToolCall call = new ToolCall();
                    call.setCallId(toolCall.getCallId());
                    call.setName(toolCall.getName());
                    call.setInput(toolCall.getInput());
                    call.setOutput(toolCall.getOutput());
                    return call;
                }).toList();
                if (StringUtils.isNotEmpty((CharSequence)finalAnswer) || !toolCalls.isEmpty()) {
                    chatResponse = GenAiChatMessage.response(finalAnswer, toolCalls);
                }
            }
        }
        ArrayList<GenAiChatMessage> messages = new ArrayList<GenAiChatMessage>();
        messages.add(chatRequest);
        if (chatResponse != null) {
            messages.add(chatResponse);
        }
        return messages;
    }

    private List<GenAiChatMessage> mapToGenAiChatMessages(StudioAssistChatReferenceContext refContext) {
        return refContext.getReferenceContexts().stream().map(ctxMessage -> new GenAiChatMessage(new GenAiChatMessageRequest(ctxMessage.getContent()), null)).toList();
    }
}

