/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.composer.folder.dialogs.ApiCollectionDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCollectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ApiCollectionHandler.class);
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    private FolderTreeEntity objectRepositoryTreeRoot;

    @CanExecute
    public static boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            this.createApiCollectionEntity(parentShell, selectedObjects, this.eventBroker);
        }
        catch (Exception e) {
            logger.error("Error creating ApiCollectionEntity", (Throwable)e);
            String errorMessage = StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_API_COLLECTION + (String)(e.getMessage() != null ? ": " + e.getMessage() : "");
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)errorMessage);
        }
    }

    @Inject
    @Optional
    private void catchObjectRepositoryTreeRoot(@Named(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            logger.error("Error caching Object Repository root", (Throwable)e);
        }
    }

    public ApiCollectionTreeEntity createApiCollectionEntity(Shell parentShell, Object[] selectedObjects, IEventBroker eventBroker) throws ControllerException, FilePathTooLongException, Exception {
        ITreeEntity parentTreeEntity = ApiCollectionHandler.findParentTreeEntity(selectedObjects);
        if (parentTreeEntity == null) {
            if (this.objectRepositoryTreeRoot == null) {
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                FolderEntity objectRepoRoot = FolderController.getInstance().getObjectRepositoryRoot(project);
                if (objectRepoRoot == null) {
                    MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_API_COLLECTION_ONLY_IN_OBJ_REPO);
                    return null;
                }
                return this.createApiCollectionAtObjectRepositoryRoot(parentShell, eventBroker);
            }
            parentTreeEntity = this.objectRepositoryTreeRoot;
        }
        FolderEntity parentFolder = (FolderEntity)parentTreeEntity.getObject();
        String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, StringConstants.HAND_NEW_API_COLLECTION);
        ApiCollectionDialog dialog = new ApiCollectionDialog(parentShell, parentFolder);
        dialog.setName(suggestedName);
        if (dialog.open() != 0) {
            return null;
        }
        ApiCollectionEntity newEntity = this.createApiCollectionEntityFromDialog(parentFolder, dialog.getName());
        if (newEntity == null) {
            return null;
        }
        FolderController.getInstance().saveFolder((FolderEntity)newEntity);
        ApiCollectionTreeEntity newFolderTreeEntity = new ApiCollectionTreeEntity(newEntity, parentTreeEntity);
        eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)newFolderTreeEntity);
        eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)newEntity);
        Trackings.trackCreateOrImportApiCollection((String)"created", (String)newEntity.getName(), (String)newEntity.getCollectionType().getDisplayName());
        return newFolderTreeEntity;
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    FolderEntity parentFolder;
                    Object parentObject;
                    ITreeEntity parent;
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof FileEntity && (parent = ((ITreeEntity)entity).getParent()) != null && (parentObject = parent.getObject()) instanceof FolderEntity && (parentFolder = (FolderEntity)parentObject).getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                        return parent;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isValidObjectRepositoryContext(FolderEntity targetFolder) {
        return targetFolder != null && targetFolder.getFolderType() == FolderEntity.FolderType.WEBELEMENT;
    }

    private ApiCollectionTreeEntity createApiCollectionAtObjectRepositoryRoot(Shell parentShell, IEventBroker eventBroker) throws ControllerException, FilePathTooLongException, Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        FolderEntity parentFolder = FolderController.getInstance().getObjectRepositoryRoot(project);
        String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, StringConstants.HAND_NEW_API_COLLECTION);
        ApiCollectionDialog dialog = new ApiCollectionDialog(parentShell, parentFolder);
        dialog.setName(suggestedName);
        if (dialog.open() != 0) {
            return null;
        }
        ApiCollectionEntity newEntity = this.createApiCollectionEntityFromDialog(parentFolder, dialog.getName());
        if (newEntity == null) {
            return null;
        }
        FolderController.getInstance().saveFolder((FolderEntity)newEntity);
        FolderTreeEntity parentTreeEntity = this.objectRepositoryTreeRoot;
        if (parentTreeEntity == null) {
            parentTreeEntity = new FolderTreeEntity(parentFolder, null);
        }
        ApiCollectionTreeEntity newFolderTreeEntity = new ApiCollectionTreeEntity(newEntity, (ITreeEntity)parentTreeEntity);
        eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)newFolderTreeEntity);
        eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)newEntity);
        Trackings.trackCreateOrImportApiCollection((String)"created", (String)newEntity.getName(), (String)newEntity.getCollectionType().getDisplayName());
        return newFolderTreeEntity;
    }

    private ApiCollectionEntity createApiCollectionEntityFromDialog(FolderEntity parentFolder, String folderName) throws Exception {
        ApiCollectionEntity newEntity = new ApiCollectionEntity();
        newEntity.setId(Util.generateGuid());
        newEntity.setName(folderName);
        newEntity.setParentFolder(parentFolder);
        newEntity.setProject(parentFolder.getProject());
        newEntity.setFolderType(FolderEntity.FolderType.WEBELEMENT);
        newEntity.setCollectionType(ApiCollectionEntity.CollectionType.MANUAL);
        File folder = new File(newEntity.getLocation());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return newEntity;
    }
}

