/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.menu;

import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.UserFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.entity.folder.FolderEntity;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class NewFolderPopupMenuContribution {
    private static final String NEW_FOLDER_POPUP_MENUITEM_LABEL = StringConstants.MENU_CONTEXT_NEW_FOLDER;
    private static final String NEW_API_COLLECTION_POPUP_MENUITEM_LABEL = StringConstants.MENU_CONTEXT_API_COLLECTION;
    private static final String NEW_FOLDER_COMMAND_ID = "com.kms.katalon.composer.folder.command.add";
    private static final String NEW_API_COLLECTION_COMMAND_ID = "com.kms.katalon.composer.folder.command.addcollection";
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    NewFolderPopupMenuContribution.this.selectionService.setSelection(null);
                    NewFolderPopupMenuContribution.this.selectionService.setSelection(selection);
                }
            }
        });
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (this.canExecute(selectedObjects)) {
                MHandledMenuItem newApiCollectionPopupMenuItem;
                MHandledMenuItem newFolderPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(NEW_FOLDER_COMMAND_ID, null), (String)NEW_FOLDER_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI());
                if (newFolderPopupMenuItem != null) {
                    menuItems.add((MMenuElement)newFolderPopupMenuItem);
                }
                if (this.canExecuteApiCollection(selectedObjects) && (newApiCollectionPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(NEW_API_COLLECTION_COMMAND_ID, null), (String)NEW_API_COLLECTION_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI())) != null) {
                    menuItems.add((MMenuElement)newApiCollectionPopupMenuItem);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canExecute(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null && selectedObjects.length > 0 && selectedObjects[0] instanceof ITreeEntity) {
            ITreeEntity parentTreeEntity = (ITreeEntity)selectedObjects[0];
            if (!(parentTreeEntity instanceof FolderTreeEntity)) return parentTreeEntity instanceof TestCaseTreeEntity || parentTreeEntity instanceof TestDataTreeEntity || parentTreeEntity instanceof TestSuiteTreeEntity || parentTreeEntity instanceof WebElementTreeEntity || parentTreeEntity instanceof TestSuiteCollectionTreeEntity || parentTreeEntity instanceof CheckpointTreeEntity || parentTreeEntity instanceof UserFileTreeEntity || parentTreeEntity instanceof WindowsElementTreeEntity;
            FolderEntity parentFolder = (FolderEntity)parentTreeEntity.getObject();
            if (parentFolder.getFolderType() != FolderEntity.FolderType.TESTCASE && parentFolder.getFolderType() != FolderEntity.FolderType.TESTSUITE && parentFolder.getFolderType() != FolderEntity.FolderType.DATAFILE && parentFolder.getFolderType() != FolderEntity.FolderType.WEBELEMENT && parentFolder.getFolderType() != FolderEntity.FolderType.CHECKPOINT && parentFolder.getFolderType() != FolderEntity.FolderType.USER) return false;
            return true;
        }
        if (selectedObjects != null && selectedObjects.length != 0) return false;
        return true;
    }

    private boolean canExecuteApiCollection(Object[] selectedObjects) throws Exception {
        FolderEntity parentFolder;
        ITreeEntity parentTreeEntity;
        return selectedObjects != null && selectedObjects.length > 0 && selectedObjects[0] instanceof ITreeEntity && ((parentTreeEntity = (ITreeEntity)selectedObjects[0]) instanceof FolderTreeEntity ? (parentFolder = (FolderEntity)parentTreeEntity.getObject()).getFolderType() == FolderEntity.FolderType.WEBELEMENT : parentTreeEntity instanceof WebElementTreeEntity);
    }
}

