/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Generator;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Piper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    public static final boolean windows = Loader.getPlatformName().startsWith("windows");
    UserClassLoader classLoader = null;
    File outputDirectory = null;
    String outputName = null;
    String jarPrefix = null;
    boolean compile = true;
    Properties properties = null;
    LinkedList<Class> classes = null;
    ClassScanner classScanner = null;
    Map<String, String> environmentVariables = null;
    LinkedList<String> compilerOptions = null;

    public static void includeJavaPaths(Properties properties) {
        String macpath;
        final String[] jnipath = new String[2];
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, "jni.h").exists()) {
                    jnipath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, "jni_md.h").exists()) {
                    jnipath[1] = dir.getAbsolutePath();
                }
                return new File(dir, name).isDirectory();
            }
        };
        File javaHome = new File(System.getProperty("java.home"));
        for (File f2 : javaHome.getParentFile().listFiles(filter)) {
            for (File f22 : f2.listFiles(filter)) {
                for (File f3 : f22.listFiles(filter)) {
                    for (File f4 : f3.listFiles(filter)) {
                    }
                }
            }
        }
        if (jnipath[0] != null && jnipath[0].equals(jnipath[1])) {
            jnipath[1] = null;
        } else if (jnipath[0] == null && new File(macpath = "/System/Library/Frameworks/JavaVM.framework/Headers/").isDirectory()) {
            jnipath[0] = macpath;
        }
        Loader.appendProperty(properties, "compiler.includepath", properties.getProperty("path.separator"), jnipath);
    }

    public int compile(Properties properties, String sourceFilename, String outputFilename) throws IOException, InterruptedException {
        String framework;
        String link;
        String includepath;
        LinkedList<String> command = new LinkedList<String>();
        Builder.includeJavaPaths(properties);
        String pathSeparator = properties.getProperty("path.separator");
        String platformRoot = properties.getProperty("platform.root");
        if (platformRoot == null || platformRoot.length() == 0) {
            platformRoot = ".";
        }
        if (!platformRoot.endsWith(File.separator)) {
            platformRoot = platformRoot + File.separator;
        }
        String compilerPath = properties.getProperty("compiler.path");
        if (platformRoot != null && !new File(compilerPath).isAbsolute() && new File(platformRoot + compilerPath).exists()) {
            compilerPath = platformRoot + compilerPath;
        }
        command.add(compilerPath);
        String sysroot = properties.getProperty("compiler.sysroot");
        if (sysroot != null && sysroot.length() > 0) {
            String p = properties.getProperty("compiler.sysroot.prefix", "");
            for (String s2 : sysroot.split(pathSeparator)) {
                if (platformRoot != null && !new File(s2).isAbsolute()) {
                    s2 = platformRoot + s2;
                }
                if (!new File(s2).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s2);
                    continue;
                }
                command.add(p + s2);
            }
        }
        if ((includepath = properties.getProperty("compiler.includepath")) != null && includepath.length() > 0) {
            String p = properties.getProperty("compiler.includepath.prefix", "");
            for (String s3 : includepath.split(pathSeparator)) {
                if (platformRoot != null && !new File(s3).isAbsolute()) {
                    s3 = platformRoot + s3;
                }
                if (!new File(s3).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s3);
                    continue;
                }
                command.add(p + s3);
            }
        }
        command.add(sourceFilename);
        String options = properties.getProperty("compiler.options");
        if (options != null && options.length() > 0) {
            command.addAll(Arrays.asList(options.split(" ")));
        }
        command.addAll(this.compilerOptions);
        String outputPrefix = properties.getProperty("compiler.output.prefix");
        if (outputPrefix != null && outputPrefix.length() > 0) {
            command.addAll(Arrays.asList(outputPrefix.split(" ")));
        }
        if (outputPrefix == null || outputPrefix.length() == 0 || outputPrefix.endsWith(" ")) {
            command.add(outputFilename);
        } else {
            command.add((String)command.removeLast() + outputFilename);
        }
        String linkpath = properties.getProperty("compiler.linkpath");
        if (linkpath != null && linkpath.length() > 0) {
            String p = properties.getProperty("compiler.linkpath.prefix", "");
            String p2 = properties.getProperty("compiler.linkpath.prefix2");
            for (String s4 : linkpath.split(pathSeparator)) {
                if (platformRoot != null && !new File(s4).isAbsolute()) {
                    s4 = platformRoot + s4;
                }
                if (!new File(s4).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s4);
                } else {
                    command.add(p + s4);
                }
                if (p2 == null) continue;
                if (p2.endsWith(" ")) {
                    command.add(p2.trim());
                    command.add(s4);
                    continue;
                }
                command.add(p2 + s4);
            }
        }
        if ((link = properties.getProperty("compiler.link")) != null && link.length() > 0) {
            String p = properties.getProperty("compiler.link.prefix", "");
            String x = properties.getProperty("compiler.link.suffix", "");
            for (String s5 : link.split(pathSeparator)) {
                String[] libnameversion = s5.split("@");
                s5 = libnameversion.length == 3 && libnameversion[1].length() == 0 ? libnameversion[0] + libnameversion[2] : libnameversion[0];
                if (p.endsWith(" ") && x.startsWith(" ")) {
                    command.add(p.trim());
                    command.add(s5);
                    command.add(x.trim());
                    continue;
                }
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s5 + x);
                    continue;
                }
                if (x.startsWith(" ")) {
                    command.add(p + s5);
                    command.add(x.trim());
                    continue;
                }
                command.add(p + s5 + x);
            }
        }
        if ((framework = properties.getProperty("compiler.framework")) != null && framework.length() > 0) {
            String p = properties.getProperty("compiler.framework.prefix", "");
            String x = properties.getProperty("compiler.framework.suffix", "");
            for (String s6 : framework.split(pathSeparator)) {
                if (p.endsWith(" ") && x.startsWith(" ")) {
                    command.add(p.trim());
                    command.add(s6);
                    command.add(x.trim());
                    continue;
                }
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s6 + x);
                    continue;
                }
                if (x.startsWith(" ")) {
                    command.add(p + s6);
                    command.add(x.trim());
                    continue;
                }
                command.add(p + s6 + x);
            }
        }
        for (String s7 : command) {
            boolean hasSpaces;
            boolean bl = hasSpaces = s7.indexOf(" ") > 0;
            if (hasSpaces) {
                System.out.print(windows ? "\"" : "'");
            }
            System.out.print(s7);
            if (hasSpaces) {
                System.out.print(windows ? "\"" : "'");
            }
            System.out.print(" ");
        }
        System.out.println();
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.environmentVariables != null) {
            pb.environment().putAll(this.environmentVariables);
        }
        Process p = pb.start();
        new Piper(p.getErrorStream(), System.err).start();
        new Piper(p.getInputStream(), System.out).start();
        return p.waitFor();
    }

    public LinkedList<File> generateAndCompile(Class[] classes, String outputName) throws IOException, InterruptedException {
        File sourceFile;
        LinkedList<File> outputFiles = new LinkedList<File>();
        Properties p = (Properties)this.properties.clone();
        for (Class c2 : classes) {
            Loader.appendProperties(p, c2);
        }
        String platformName = p.getProperty("platform.name");
        String sourceSuffix = p.getProperty("source.suffix", ".cpp");
        String libraryName = p.getProperty("library.prefix", "") + outputName + p.getProperty("library.suffix", "");
        File outputDirectory = this.outputDirectory;
        if (outputDirectory == null) {
            try {
                URL resourceURL = classes[0].getResource(classes[0].getSimpleName() + ".class");
                File packageDir = new File(resourceURL.toURI()).getParentFile();
                outputDirectory = new File(packageDir, platformName);
                sourceFile = new File(packageDir, outputName + sourceSuffix);
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            sourceFile = new File(outputDirectory, outputName + sourceSuffix);
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        System.out.println("Generating source file: " + sourceFile);
        Generator generator = new Generator(p, sourceFile);
        boolean generatedSomething = generator.generate(classes);
        generator.close();
        if (generatedSomething) {
            if (this.compile) {
                File libraryFile = new File(outputDirectory, libraryName);
                System.out.println("Building library file: " + libraryFile);
                int exitValue = this.compile(p, sourceFile.getPath(), libraryFile.getPath());
                if (exitValue == 0) {
                    sourceFile.delete();
                    outputFiles.add(libraryFile);
                } else {
                    System.exit(exitValue);
                }
            } else {
                outputFiles.add(sourceFile);
            }
        } else {
            System.out.println("Source file not generated: " + sourceFile);
        }
        return outputFiles;
    }

    public static void createJar(File jarFile, String[] classpath, LinkedList<File> files) throws IOException {
        System.out.println("Creating JAR file: " + jarFile);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (File f2 : files) {
            int n2;
            String name = f2.getPath();
            if (classpath != null) {
                int i2;
                String[] names = new String[classpath.length];
                for (i2 = 0; i2 < classpath.length; ++i2) {
                    String path = new File(classpath[i2]).getCanonicalPath();
                    if (!name.startsWith(path)) continue;
                    names[i2] = name.substring(path.length() + 1);
                }
                for (i2 = 0; i2 < names.length; ++i2) {
                    if (names[i2] == null || names[i2].length() >= name.length()) continue;
                    name = names[i2];
                }
            }
            ZipEntry e2 = new ZipEntry(name.replace(File.separatorChar, '/'));
            e2.setTime(f2.lastModified());
            jos.putNextEntry(e2);
            FileInputStream fis = new FileInputStream(f2);
            byte[] data = new byte[fis.available()];
            while ((n2 = fis.read(data)) > 0) {
                jos.write(data, 0, n2);
            }
            fis.close();
            jos.closeEntry();
        }
        jos.close();
    }

    public Builder() {
        Loader.loadLibraries = false;
        this.classLoader = new UserClassLoader(Thread.currentThread().getContextClassLoader());
        this.properties = Loader.getProperties();
        this.classes = new LinkedList();
        this.classScanner = new ClassScanner(this.classes, this.classLoader);
        this.compilerOptions = new LinkedList();
    }

    public Builder classPaths(String classPaths) {
        this.classPaths(classPaths == null ? null : classPaths.split(File.pathSeparator));
        return this;
    }

    public Builder classPaths(String ... classPaths) {
        this.classLoader.addPaths(classPaths);
        return this;
    }

    public Builder outputDirectory(String outputDirectory) {
        this.outputDirectory(outputDirectory == null ? null : new File(outputDirectory));
        return this;
    }

    public Builder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public Builder compile(boolean compile) {
        this.compile = compile;
        return this;
    }

    public Builder outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    public Builder jarPrefix(String jarPrefix) {
        this.jarPrefix = jarPrefix;
        return this;
    }

    public Builder properties(String platformName) {
        this.properties(platformName == null ? null : Loader.getProperties(platformName));
        return this;
    }

    public Builder properties(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public Builder propertyFile(String filename) throws IOException {
        this.propertyFile(filename == null ? null : new File(filename));
        return this;
    }

    public Builder propertyFile(File propertyFile) throws IOException {
        if (propertyFile == null) {
            return this;
        }
        FileInputStream fis = new FileInputStream(propertyFile);
        this.properties = new Properties(this.properties);
        try {
            this.properties.load(new InputStreamReader(fis));
        }
        catch (NoSuchMethodError e2) {
            this.properties.load(fis);
        }
        fis.close();
        return this;
    }

    public Builder property(String keyValue) {
        int equalIndex = keyValue.indexOf(61);
        if (equalIndex < 0) {
            equalIndex = keyValue.indexOf(58);
        }
        this.property(keyValue.substring(2, equalIndex), keyValue.substring(equalIndex + 1));
        return this;
    }

    public Builder property(String key, String value) {
        if (key.length() > 0 && value.length() > 0) {
            this.properties.put(key, value);
        }
        return this;
    }

    public Builder classesOrPackages(String ... classesOrPackages) throws IOException {
        for (String s2 : classesOrPackages) {
            this.classScanner.addClassOrPackage(s2);
        }
        return this;
    }

    public Builder environmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Builder compilerOptions(String ... options) {
        if (options != null) {
            this.compilerOptions.addAll(Arrays.asList(options));
        }
        return this;
    }

    public Collection<File> build() throws IOException, InterruptedException {
        LinkedList<Object> outputFiles;
        if (this.classes.isEmpty()) {
            this.classScanner.addPackage(null, true);
        }
        if (this.outputName == null) {
            outputFiles = new LinkedList();
            for (Class c2 : this.classes) {
                outputFiles.addAll(this.generateAndCompile(new Class[]{c2}, Loader.getLibraryName(c2)));
            }
        } else {
            outputFiles = this.generateAndCompile(this.classes.toArray(new Class[this.classes.size()]), this.outputName);
        }
        if (this.jarPrefix != null && !outputFiles.isEmpty()) {
            File jarFile = new File(this.jarPrefix + "-" + this.properties.get("platform.name") + ".jar");
            File d2 = jarFile.getParentFile();
            if (d2 != null && !d2.exists()) {
                d2.mkdir();
            }
            Builder.createJar(jarFile, this.outputDirectory == null ? this.classLoader.getPaths() : null, outputFiles);
        }
        return outputFiles;
    }

    public static void printHelp() {
        String version = Builder.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        System.out.println("JavaCPP version " + version + "\n" + "Copyright (C) 2011-2012 Samuel Audet <samuel.audet@gmail.com>\n" + "Project site: http://code.google.com/p/javacpp/\n\n" + "Licensed under the GNU General Public License version 2 (GPLv2) with Classpath exception.\n" + "Please refer to LICENSE.txt or http://www.gnu.org/licenses/ for details.");
        System.out.println();
        System.out.println("Usage: java -jar javacpp.jar [options] [class or package names]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("    -classpath <path>      Load user classes from path");
        System.out.println("    -d <directory>         Output all generated files to directory");
        System.out.println("    -o <name>              Output everything in a file named after given name");
        System.out.println("    -nocompile             Do not compile or delete the generated source files");
        System.out.println("    -jarprefix <prefix>    Also create a JAR file named \"<prefix>-<platform.name>.jar\"");
        System.out.println("    -properties <resource> Load all properties from resource");
        System.out.println("    -propertyfile <file>   Load all properties from file");
        System.out.println("    -D<property>=<value>   Set property to value");
        System.out.println("    -Xcompiler <option>    Pass option directly to compiler");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Builder builder = new Builder();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-help".equals(args[i2]) || "--help".equals(args[i2])) {
                Builder.printHelp();
                System.exit(0);
                continue;
            }
            if ("-classpath".equals(args[i2]) || "-cp".equals(args[i2]) || "-lib".equals(args[i2])) {
                builder.classPaths(args[++i2]);
                continue;
            }
            if ("-d".equals(args[i2])) {
                builder.outputDirectory(args[++i2]);
                continue;
            }
            if ("-o".equals(args[i2])) {
                builder.outputName(args[++i2]);
                continue;
            }
            if ("-cpp".equals(args[i2]) || "-nocompile".equals(args[i2])) {
                builder.compile(false);
                continue;
            }
            if ("-jarprefix".equals(args[i2])) {
                builder.jarPrefix(args[++i2]);
                continue;
            }
            if ("-properties".equals(args[i2])) {
                builder.properties(args[++i2]);
                continue;
            }
            if ("-propertyfile".equals(args[i2])) {
                builder.propertyFile(args[++i2]);
                continue;
            }
            if (args[i2].startsWith("-D")) {
                builder.property(args[i2]);
                continue;
            }
            if ("-Xcompiler".equals(args[i2])) {
                builder.compilerOptions(args[++i2]);
                continue;
            }
            if (args[i2].startsWith("-")) {
                System.err.println("Error: Invalid option \"" + args[i2] + "\"");
                Builder.printHelp();
                System.exit(1);
                continue;
            }
            builder.classesOrPackages(args[i2]);
        }
        builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassScanner {
        private Collection<Class> classes;
        private UserClassLoader loader;

        public ClassScanner(Collection<Class> classes, UserClassLoader loader) {
            this.classes = classes;
            this.loader = loader;
        }

        public void addClass(String className) {
            if (className == null || className.indexOf(36) > 0) {
                return;
            }
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            try {
                Class<?> c2 = Class.forName(className, true, this.loader);
                if (!this.classes.contains(c2)) {
                    this.classes.add(c2);
                }
            }
            catch (ClassNotFoundException e2) {
                System.err.println("Warning: Could not find class " + className + ": " + e2);
            }
            catch (NoClassDefFoundError e3) {
                System.err.println("Warning: Could not load class " + className + ": " + e3);
            }
        }

        public void addMatchingFile(String filename, String packagePath, boolean recursive) {
            if (filename != null && filename.endsWith(".class") && filename.indexOf(36) < 0 && (packagePath == null || recursive && filename.startsWith(packagePath) || filename.regionMatches(0, packagePath, 0, Math.max(filename.lastIndexOf(47), packagePath.lastIndexOf(47))))) {
                this.addClass(filename.replace('/', '.'));
            }
        }

        public void addMatchingDir(String parentName, File dir, String packagePath, boolean recursive) {
            Object[] files = dir.listFiles();
            Arrays.sort(files);
            for (Object f2 : files) {
                String pathName;
                String string = pathName = parentName == null ? ((File)f2).getName() : parentName + ((File)f2).getName();
                if (((File)f2).isDirectory()) {
                    this.addMatchingDir(pathName + "/", (File)f2, packagePath, recursive);
                    continue;
                }
                this.addMatchingFile(pathName, packagePath, recursive);
            }
        }

        public void addPackage(String packageName, boolean recursive) throws IOException {
            String[] paths = this.loader.getPaths();
            String packagePath = packageName == null ? null : packageName.replace('.', '/') + "/";
            int prevSize = this.classes.size();
            for (String p : paths) {
                File file = new File(p);
                if (file.isDirectory()) {
                    this.addMatchingDir(null, file, packagePath, recursive);
                    continue;
                }
                JarInputStream jis = new JarInputStream(new FileInputStream(file));
                ZipEntry e2 = jis.getNextEntry();
                while (e2 != null) {
                    this.addMatchingFile(e2.getName(), packagePath, recursive);
                    jis.closeEntry();
                    e2 = jis.getNextEntry();
                }
                jis.close();
            }
            if (prevSize == this.classes.size()) {
                if (packageName == null) {
                    System.err.println("Warning: No classes found in the unnamed package");
                    Builder.printHelp();
                } else {
                    System.err.println("Warning: No classes found in package " + packageName);
                }
            }
        }

        public void addClassOrPackage(String name) throws IOException {
            if (name == null) {
                return;
            }
            if ((name = name.replace('/', '.')).endsWith(".**")) {
                this.addPackage(name.substring(0, name.length() - 3), true);
            } else if (name.endsWith(".*")) {
                this.addPackage(name.substring(0, name.length() - 2), false);
            } else {
                this.addClass(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserClassLoader
    extends URLClassLoader {
        private LinkedList<String> paths = new LinkedList();

        public UserClassLoader() {
            super(new URL[0]);
        }

        public UserClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addPaths(String ... paths) {
            if (paths == null) {
                return;
            }
            for (String path : paths) {
                this.paths.add(path);
                try {
                    this.addURL(new File(path).toURI().toURL());
                }
                catch (MalformedURLException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }

        public String[] getPaths() {
            if (this.paths.isEmpty()) {
                this.addPaths(System.getProperty("user.dir"));
            }
            return this.paths.toArray(new String[this.paths.size()]);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.paths.isEmpty()) {
                this.addPaths(System.getProperty("user.dir"));
            }
            return super.findClass(name);
        }
    }
}

