/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileRGB;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class CanvasFrame
extends JFrame {
    public static CanvasFrame global = null;
    public static final long DEFAULT_LATENCY = 200L;
    private long latency = 200L;
    private KeyEvent keyEvent = null;
    private KeyEventDispatcher keyEventDispatch = new KeyEventDispatcher(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatchKeyEvent(KeyEvent e2) {
            if (e2.getID() == 401) {
                CanvasFrame canvasFrame = CanvasFrame.this;
                synchronized (canvasFrame) {
                    CanvasFrame.this.keyEvent = e2;
                    CanvasFrame.this.notify();
                }
            }
            return false;
        }
    };
    protected Canvas canvas = null;
    protected boolean needInitialResize = false;
    protected double initialScale = 1.0;
    protected double inverseGamma = 1.0;
    private BufferStrategy bufferStrategy = null;

    public static String[] getScreenDescriptions() {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        String[] descriptions = new String[screens.length];
        for (int i2 = 0; i2 < screens.length; ++i2) {
            descriptions[i2] = screens[i2].getIDstring();
        }
        return descriptions;
    }

    public static DisplayMode getDisplayMode(int screenNumber) {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= 0 && screenNumber < screens.length) {
            return screens[screenNumber].getDisplayMode();
        }
        return null;
    }

    public static double getGamma(int screenNumber) {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= 0 && screenNumber < screens.length) {
            return CanvasFrame.getGamma(screens[screenNumber]);
        }
        return 0.0;
    }

    public static double getDefaultGamma() {
        return CanvasFrame.getGamma(CanvasFrame.getDefaultScreenDevice());
    }

    public static double getGamma(GraphicsDevice screen) {
        ColorSpace cs = screen.getDefaultConfiguration().getColorModel().getColorSpace();
        if (cs.isCS_sRGB()) {
            return 2.2;
        }
        try {
            return ((ICC_ProfileRGB)((ICC_ColorSpace)cs).getProfile()).getGamma(0);
        }
        catch (RuntimeException runtimeException) {
            return 0.0;
        }
    }

    public static GraphicsDevice getScreenDevice(int screenNumber) throws Exception {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= screens.length) {
            throw new Exception("CanvasFrame Error: Screen number " + screenNumber + " not found. " + "There are only " + screens.length + " screens.");
        }
        return screens[screenNumber];
    }

    public static GraphicsDevice[] getScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    public static GraphicsDevice getDefaultScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    public CanvasFrame(String title) {
        this(title, 0.0);
    }

    public CanvasFrame(String title, double gamma) {
        super(title);
        this.init(false, null, gamma);
    }

    public CanvasFrame(String title, GraphicsConfiguration gc) {
        this(title, gc, 0.0);
    }

    public CanvasFrame(String title, GraphicsConfiguration gc, double gamma) {
        super(title, gc);
        this.init(false, null, gamma);
    }

    public CanvasFrame(String title, int screenNumber, DisplayMode displayMode) throws Exception {
        this(title, screenNumber, displayMode, 0.0);
    }

    public CanvasFrame(String title, int screenNumber, DisplayMode displayMode, double gamma) throws Exception {
        super(title, CanvasFrame.getScreenDevice(screenNumber).getDefaultConfiguration());
        this.init(true, displayMode, gamma);
    }

    private void init(final boolean fullScreen, final DisplayMode displayMode, final double gamma) {
        Runnable r = new Runnable(){

            public void run() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(CanvasFrame.this.keyEventDispatch);
                GraphicsDevice gd = CanvasFrame.this.getGraphicsConfiguration().getDevice();
                DisplayMode d2 = gd.getDisplayMode();
                DisplayMode d22 = null;
                if (displayMode != null && d2 != null) {
                    int w = displayMode.getWidth();
                    int h2 = displayMode.getHeight();
                    int b2 = displayMode.getBitDepth();
                    int r = displayMode.getRefreshRate();
                    d22 = new DisplayMode(w > 0 ? w : d2.getWidth(), h2 > 0 ? h2 : d2.getHeight(), b2 > 0 ? b2 : d2.getBitDepth(), r > 0 ? r : d2.getRefreshRate());
                }
                if (fullScreen) {
                    CanvasFrame.this.setUndecorated(true);
                    CanvasFrame.this.getRootPane().setWindowDecorationStyle(0);
                    CanvasFrame.this.setResizable(false);
                    gd.setFullScreenWindow(CanvasFrame.this);
                } else {
                    CanvasFrame.this.setLocationByPlatform(true);
                }
                if (d22 != null && !d22.equals(d2)) {
                    gd.setDisplayMode(d22);
                }
                double g2 = gamma == 0.0 ? CanvasFrame.getGamma(gd) : gamma;
                CanvasFrame.this.inverseGamma = g2 == 0.0 ? 1.0 : 1.0 / g2;
                CanvasFrame.this.setVisible(true);
                if (CanvasFrame.this.getClass() == CanvasFrame.class) {
                    CanvasFrame.this.canvas = new Canvas(){

                        public void paint(Graphics g2) {
                            try {
                                CanvasFrame.this.bufferStrategy.show();
                            }
                            catch (NullPointerException e2) {
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                        }
                    };
                    if (fullScreen) {
                        CanvasFrame.this.canvas.setSize(CanvasFrame.this.getSize());
                        CanvasFrame.this.needInitialResize = false;
                    } else {
                        CanvasFrame.this.needInitialResize = true;
                    }
                    CanvasFrame.this.getContentPane().add(CanvasFrame.this.canvas);
                    CanvasFrame.this.canvas.setVisible(true);
                    CanvasFrame.this.canvas.createBufferStrategy(2);
                    CanvasFrame.this.bufferStrategy = CanvasFrame.this.canvas.getBufferStrategy();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (java.lang.Exception ex) {
                // empty catch block
            }
        }
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void waitLatency() throws InterruptedException {
        Thread.sleep(this.getLatency());
    }

    public KeyEvent waitKey() throws InterruptedException {
        return this.waitKey(0);
    }

    public synchronized KeyEvent waitKey(int delay) throws InterruptedException {
        this.keyEvent = null;
        this.wait(delay);
        KeyEvent e2 = this.keyEvent;
        this.keyEvent = null;
        return e2;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public Dimension getCanvasSize() {
        return this.canvas.getSize();
    }

    public void setCanvasSize(final int width, final int height) {
        Dimension d2 = this.getCanvasSize();
        if (d2.width == width && d2.height == height) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                CanvasFrame.this.setExtendedState(0);
                CanvasFrame.this.canvas.setSize(width, height);
                CanvasFrame.this.pack();
                CanvasFrame.this.canvas.setSize(width + 1, height + 1);
                CanvasFrame.this.canvas.setSize(width, height);
                CanvasFrame.this.needInitialResize = false;
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (java.lang.Exception ex) {
                // empty catch block
            }
        }
    }

    public double getCanvasScale() {
        return this.initialScale;
    }

    public void setCanvasScale(double initialScale) {
        this.initialScale = initialScale;
        this.needInitialResize = true;
    }

    public Graphics2D createGraphics() {
        return (Graphics2D)this.bufferStrategy.getDrawGraphics();
    }

    public void releaseGraphics(Graphics2D g2) {
        g2.dispose();
        this.bufferStrategy.show();
    }

    public void showColor(opencv_core.CvScalar color) {
        this.showColor(new Color((int)color.red(), (int)color.green(), (int)color.blue()));
    }

    public void showColor(Color color) {
        Graphics2D g2 = this.createGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        this.releaseGraphics(g2);
    }

    public void showImage(opencv_core.IplImage image) {
        this.showImage(image, false);
    }

    public void showImage(opencv_core.IplImage image, boolean flipChannels) {
        this.showImage(image.getBufferedImage(image.getBufferedImageType() == 0 ? 1.0 : this.inverseGamma, flipChannels));
    }

    public void showImage(Image image) {
        if (image == null) {
            return;
        }
        if (this.isResizable() && this.needInitialResize) {
            int w = (int)Math.round((double)image.getWidth(null) * this.initialScale);
            int h2 = (int)Math.round((double)image.getHeight(null) * this.initialScale);
            this.setCanvasSize(w, h2);
        }
        Graphics2D g2 = this.createGraphics();
        g2.drawImage(image, 0, 0, this.canvas.getWidth(), this.canvas.getHeight(), null);
        this.releaseGraphics(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tile(final CanvasFrame[] frames) {
        class MovedListener
        extends ComponentAdapter {
            boolean moved = false;

            MovedListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentMoved(ComponentEvent e2) {
                Component c2;
                this.moved = true;
                Component component = c2 = e2.getComponent();
                synchronized (component) {
                    c2.notify();
                }
            }
        }
        final MovedListener movedListener = new MovedListener();
        int canvasCols = (int)Math.round(Math.sqrt(frames.length));
        if (canvasCols * canvasCols < frames.length) {
            ++canvasCols;
        }
        int canvasX = 0;
        int canvasY = 0;
        int canvasMaxY = 0;
        for (int i2 = 0; i2 < frames.length; ++i2) {
            final int n2 = i2;
            final int x = canvasX;
            final int y = canvasY;
            try {
                movedListener.moved = false;
                EventQueue.invokeLater(new Runnable(){
                    {
                    }

                    public void run() {
                        frames[n2].addComponentListener(movedListener);
                        frames[n2].setLocation(x, y);
                    }
                });
                for (int count = 0; !movedListener.moved && count < 5; ++count) {
                    CanvasFrame canvasFrame = frames[n2];
                    synchronized (canvasFrame) {
                        frames[n2].wait(100L);
                        continue;
                    }
                }
                EventQueue.invokeLater(new Runnable(){
                    {
                    }

                    public void run() {
                        frames[n2].removeComponentListener(movedListener);
                    }
                });
            }
            catch (java.lang.Exception ex) {
                // empty catch block
            }
            canvasX = frames[i2].getX() + frames[i2].getWidth();
            canvasMaxY = Math.max(canvasMaxY, frames[i2].getY() + frames[i2].getHeight());
            if ((i2 + 1) % canvasCols != 0) continue;
            canvasX = 0;
            canvasY = canvasMaxY;
        }
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

