/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.ProjectiveDevice;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Color;

public class ColorCalibrator {
    private ProjectiveDevice device;

    public ColorCalibrator(ProjectiveDevice device) {
        this.device = device;
    }

    public double calibrate(Color[] referenceColors, Color[] deviceColors) {
        assert (referenceColors.length == deviceColors.length);
        int[] order = this.device.getRGBColorOrder();
        opencv_core.CvMat A2 = opencv_core.CvMat.create(referenceColors.length * 3, 12);
        opencv_core.CvMat b2 = opencv_core.CvMat.create(referenceColors.length * 3, 1);
        opencv_core.CvMat x = opencv_core.CvMat.create(12, 1);
        double gamma = this.device.getSettings().getResponseGamma();
        for (int i2 = 0; i2 < referenceColors.length; ++i2) {
            float[] dc = deviceColors[i2].getRGBColorComponents(null);
            float[] rc = referenceColors[i2].getRGBColorComponents(null);
            double dc1 = Math.pow(dc[order[0]], gamma);
            double dc2 = Math.pow(dc[order[1]], gamma);
            double dc3 = Math.pow(dc[order[2]], gamma);
            for (int j2 = 0; j2 < 3; ++j2) {
                int k2 = i2 * 36 + j2 * 16;
                A2.put(k2, dc1);
                A2.put(k2 + 1, dc2);
                A2.put(k2 + 2, dc3);
                A2.put(k2 + 3, 1.0);
                if (j2 >= 2) continue;
                for (int m3 = 0; m3 < 12; ++m3) {
                    A2.put(k2 + 4 + m3, 0.0);
                }
            }
            b2.put(i2 * 3, (double)rc[order[0]]);
            b2.put(i2 * 3 + 1, (double)rc[order[1]]);
            b2.put(i2 * 3 + 2, (double)rc[order[2]]);
        }
        if ((double)opencv_core.cvSolve(A2, b2, x, 1) != 1.0) {
            System.out.println("Error solving.");
        }
        opencv_core.CvMat b22 = opencv_core.CvMat.create(b2.rows(), 1);
        opencv_core.cvMatMul(A2, x, b22);
        double MSE = opencv_core.cvNorm(b2, b22) * opencv_core.cvNorm(b2, b22) / (double)b2.rows();
        double RMSE = Math.sqrt(MSE);
        opencv_core.CvScalar mean = new opencv_core.CvScalar();
        opencv_core.CvScalar stddev = new opencv_core.CvScalar();
        opencv_core.cvAvgSdv(b2, mean, stddev, null);
        double R2 = 1.0 - MSE / (stddev.val(0) * stddev.val(0));
        this.device.colorMixingMatrix = opencv_core.CvMat.create(3, 3);
        this.device.additiveLight = opencv_core.CvMat.create(3, 1);
        for (int i3 = 0; i3 < 3; ++i3) {
            double x0 = x.get(i3 * 4);
            double x1 = x.get(i3 * 4 + 1);
            double x2 = x.get(i3 * 4 + 2);
            double x3 = x.get(i3 * 4 + 3);
            this.device.colorMixingMatrix.put(i3 * 3, x0);
            this.device.colorMixingMatrix.put(i3 * 3 + 1, x1);
            this.device.colorMixingMatrix.put(i3 * 3 + 2, x2);
            this.device.additiveLight.put(i3, x3);
        }
        this.device.colorR2 = R2;
        this.device.avgColorErr = RMSE;
        return this.device.avgColorErr;
    }
}

