/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.DC1394FrameGrabber;
import com.googlecode.javacv.FFmpegFrameGrabber;
import com.googlecode.javacv.FlyCaptureFrameGrabber;
import com.googlecode.javacv.OpenCVFrameGrabber;
import com.googlecode.javacv.OpenKinectFrameGrabber;
import com.googlecode.javacv.PS3EyeFrameGrabber;
import com.googlecode.javacv.VideoInputFrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameGrabber {
    public static final List<Class<? extends FrameGrabber>> list = new LinkedList<Class<? extends FrameGrabber>>();
    public static final long SENSOR_PATTERN_RGGB = 0L;
    public static final long SENSOR_PATTERN_GBRG = 0x100000000L;
    public static final long SENSOR_PATTERN_GRBG = 1L;
    public static final long SENSOR_PATTERN_BGGR = 0x100000001L;
    protected String format = null;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected ImageMode imageMode = ImageMode.COLOR;
    protected long sensorPattern = -1L;
    protected int pixelFormat = -1;
    protected double frameRate = 0.0;
    protected boolean triggerMode = false;
    protected int bpp = 0;
    protected int timeout = 10000;
    protected int numBuffers = 4;
    protected double gamma = 0.0;
    protected boolean deinterlace = false;
    protected int frameNumber = 0;
    protected long timestamp = 0L;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<Void> future = null;
    private opencv_core.IplImage delayedImage = null;
    private long delayedTime = 0L;

    public static void init() {
        for (Class<? extends FrameGrabber> c2 : list) {
            try {
                c2.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    public static Class<? extends FrameGrabber> getDefault() {
        for (Class<? extends FrameGrabber> c2 : list) {
            try {
                boolean mayContainCameras;
                block6: {
                    c2.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
                    mayContainCameras = false;
                    try {
                        String[] s2 = (String[])c2.getMethod("getDeviceDescriptions", new Class[0]).invoke(null, new Object[0]);
                        if (s2.length > 0) {
                            mayContainCameras = true;
                        }
                    }
                    catch (Throwable t) {
                        if (!(t.getCause() instanceof UnsupportedOperationException)) break block6;
                        mayContainCameras = true;
                    }
                }
                if (!mayContainCameras) continue;
                return c2;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Class<? extends FrameGrabber> get(String className) throws Exception {
        className = FrameGrabber.class.getPackage().getName() + "." + className;
        try {
            return Class.forName(className).asSubclass(FrameGrabber.class);
        }
        catch (ClassNotFoundException e2) {
            String className2 = className + "FrameGrabber";
            try {
                return Class.forName(className2).asSubclass(FrameGrabber.class);
            }
            catch (ClassNotFoundException ex) {
                throw new Exception("Could not get FrameGrabber class for " + className + " or " + className2, e2);
            }
        }
    }

    public static FrameGrabber create(Class<? extends FrameGrabber> c2, Class p, Object o2) throws Exception {
        java.lang.Exception cause = null;
        try {
            return c2.getConstructor(p).newInstance(o2);
        }
        catch (InstantiationException ex) {
            cause = ex;
        }
        catch (IllegalAccessException ex) {
            cause = ex;
        }
        catch (IllegalArgumentException ex) {
            cause = ex;
        }
        catch (NoSuchMethodException ex) {
            cause = ex;
        }
        catch (InvocationTargetException ex) {
            cause = ex;
        }
        throw new Exception("Could not create new " + c2.getSimpleName() + "(" + o2 + ")", cause);
    }

    public static FrameGrabber createDefault(File deviceFile) throws Exception {
        return FrameGrabber.create(FrameGrabber.getDefault(), File.class, deviceFile);
    }

    public static FrameGrabber createDefault(String devicePath) throws Exception {
        return FrameGrabber.create(FrameGrabber.getDefault(), String.class, devicePath);
    }

    public static FrameGrabber createDefault(int deviceNumber) throws Exception {
        try {
            return FrameGrabber.create(FrameGrabber.getDefault(), Integer.TYPE, deviceNumber);
        }
        catch (Exception ex) {
            return FrameGrabber.create(FrameGrabber.getDefault(), Integer.class, deviceNumber);
        }
    }

    public static FrameGrabber create(String className, File deviceFile) throws Exception {
        return FrameGrabber.create(FrameGrabber.get(className), File.class, deviceFile);
    }

    public static FrameGrabber create(String className, String devicePath) throws Exception {
        return FrameGrabber.create(FrameGrabber.get(className), String.class, devicePath);
    }

    public static FrameGrabber create(String className, int deviceNumber) throws Exception {
        try {
            return FrameGrabber.create(FrameGrabber.get(className), Integer.TYPE, deviceNumber);
        }
        catch (Exception ex) {
            return FrameGrabber.create(FrameGrabber.get(className), Integer.class, deviceNumber);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public ImageMode getImageMode() {
        return this.imageMode;
    }

    public void setImageMode(ImageMode imageMode) {
        this.imageMode = imageMode;
    }

    public long getSensorPattern() {
        return this.sensorPattern;
    }

    public void setSensorPattern(long sensorPattern) {
        this.sensorPattern = sensorPattern;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public boolean isTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(boolean triggerMode) {
        this.triggerMode = triggerMode;
    }

    public int getBitsPerPixel() {
        return this.bpp;
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bpp = bitsPerPixel;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getNumBuffers() {
        return this.numBuffers;
    }

    public void setNumBuffers(int numBuffers) {
        this.numBuffers = numBuffers;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean deinterlace) {
        this.deinterlace = deinterlace;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(int frameNumber) throws Exception {
        this.frameNumber = frameNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) throws Exception {
        this.timestamp = timestamp;
    }

    public int getLengthInFrames() {
        return 0;
    }

    public long getLengthInTime() {
        return 0L;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void trigger() throws Exception;

    public abstract opencv_core.IplImage grab() throws Exception;

    public abstract void release() throws Exception;

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void flush() throws Exception {
        for (int i2 = 0; i2 < this.numBuffers + 1; ++i2) {
            this.grab();
        }
    }

    public void delayedGrab(final long delayTime) {
        this.delayedImage = null;
        this.delayedTime = 0L;
        final long start = System.nanoTime() / 1000L;
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        this.future = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                do {
                    FrameGrabber.this.delayedImage = FrameGrabber.this.grab();
                    FrameGrabber.this.delayedTime = System.nanoTime() / 1000L - start;
                } while (FrameGrabber.this.delayedTime < delayTime);
                return null;
            }
        });
    }

    public long getDelayedTime() throws InterruptedException, ExecutionException {
        if (this.future == null) {
            return 0L;
        }
        this.future.get();
        return this.delayedTime;
    }

    public opencv_core.IplImage getDelayedImage() throws InterruptedException, ExecutionException {
        if (this.future == null) {
            return null;
        }
        this.future.get();
        return this.delayedImage;
    }

    public Array createArray(FrameGrabber[] frameGrabbers) {
        return new Array(frameGrabbers);
    }

    static {
        list.add(DC1394FrameGrabber.class);
        list.add(FlyCaptureFrameGrabber.class);
        list.add(OpenKinectFrameGrabber.class);
        list.add(PS3EyeFrameGrabber.class);
        list.add(VideoInputFrameGrabber.class);
        list.add(OpenCVFrameGrabber.class);
        list.add(FFmpegFrameGrabber.class);
    }

    public static class Array {
        private opencv_core.IplImage[] grabbedImages = null;
        private long[] latencies = null;
        private long[] bestLatencies = null;
        private long lastNewestTimestamp = 0L;
        private long bestInterval = Long.MAX_VALUE;
        protected FrameGrabber[] frameGrabbers = null;

        protected Array(FrameGrabber[] frameGrabbers) {
            this.setFrameGrabbers(frameGrabbers);
        }

        public FrameGrabber[] getFrameGrabbers() {
            return this.frameGrabbers;
        }

        public void setFrameGrabbers(FrameGrabber[] frameGrabbers) {
            this.frameGrabbers = frameGrabbers;
            this.grabbedImages = new opencv_core.IplImage[frameGrabbers.length];
            this.latencies = new long[frameGrabbers.length];
            this.bestLatencies = null;
            this.lastNewestTimestamp = 0L;
        }

        public int size() {
            return this.frameGrabbers.length;
        }

        public void start() throws Exception {
            for (FrameGrabber f2 : this.frameGrabbers) {
                f2.start();
            }
        }

        public void stop() throws Exception {
            for (FrameGrabber f2 : this.frameGrabbers) {
                f2.stop();
            }
        }

        public void trigger() throws Exception {
            for (FrameGrabber f2 : this.frameGrabbers) {
                if (!f2.isTriggerMode()) continue;
                f2.trigger();
            }
        }

        public opencv_core.IplImage[] grab() throws Exception {
            int i2;
            if (this.frameGrabbers.length == 1) {
                this.grabbedImages[0] = this.frameGrabbers[0].grab();
                return this.grabbedImages;
            }
            long newestTimestamp = 0L;
            for (i2 = 0; i2 < this.frameGrabbers.length; ++i2) {
                this.grabbedImages[i2] = this.frameGrabbers[i2].grab();
                if (this.grabbedImages[i2] == null) continue;
                newestTimestamp = Math.max(newestTimestamp, this.frameGrabbers[i2].getTimestamp());
            }
            for (i2 = 0; i2 < this.frameGrabbers.length; ++i2) {
                if (this.grabbedImages[i2] == null) continue;
                this.latencies[i2] = newestTimestamp - this.frameGrabbers[i2].getTimestamp();
            }
            if (this.bestLatencies == null) {
                this.bestLatencies = Arrays.copyOf(this.latencies, this.latencies.length);
            } else {
                int sum1 = 0;
                int sum2 = 0;
                for (int i3 = 0; i3 < this.frameGrabbers.length; ++i3) {
                    sum1 = (int)((long)sum1 + this.latencies[i3]);
                    sum2 = (int)((long)sum2 + this.bestLatencies[i3]);
                }
                if (sum1 < sum2) {
                    this.bestLatencies = Arrays.copyOf(this.latencies, this.latencies.length);
                }
            }
            this.bestInterval = Math.min(this.bestInterval, newestTimestamp - this.lastNewestTimestamp);
            for (i2 = 0; i2 < this.bestLatencies.length; ++i2) {
                this.bestLatencies[i2] = Math.min(this.bestLatencies[i2], this.bestInterval * 9L / 10L);
            }
            for (int j2 = 0; j2 < 2; ++j2) {
                block5: for (int i4 = 0; i4 < this.frameGrabbers.length; ++i4) {
                    if (this.frameGrabbers[i4].isTriggerMode() || this.grabbedImages[i4] == null) continue;
                    int latency = (int)(newestTimestamp - this.frameGrabbers[i4].getTimestamp());
                    while ((double)((long)latency - this.bestLatencies[i4]) > 0.1 * (double)this.bestLatencies[i4]) {
                        this.grabbedImages[i4] = this.frameGrabbers[i4].grab();
                        if (this.grabbedImages[i4] == null) continue block5;
                        latency = (int)(newestTimestamp - this.frameGrabbers[i4].getTimestamp());
                        if (latency >= 0) continue;
                        newestTimestamp = this.frameGrabbers[i4].getTimestamp();
                        continue block5;
                    }
                }
            }
            this.lastNewestTimestamp = newestTimestamp;
            return this.grabbedImages;
        }

        public void release() throws Exception {
            for (FrameGrabber f2 : this.frameGrabbers) {
                f2.release();
            }
        }
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageMode {
        COLOR,
        GRAY,
        RAW;

    }

    public static class PropertyEditor
    extends PropertyEditorSupport {
        public String getAsText() {
            Class c2 = (Class)this.getValue();
            return c2 == null ? "null" : c2.getSimpleName();
        }

        public void setAsText(String s2) {
            if (s2 == null) {
                this.setValue(null);
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Class<? extends FrameGrabber> c2 = list.get(i2);
                if (!s2.equals(c2.getSimpleName())) continue;
                this.setValue(c2);
            }
        }

        public String[] getTags() {
            String[] s2 = new String[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                s2[i2] = list.get(i2).getSimpleName();
            }
            return s2;
        }
    }
}

