/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import com.googlecode.javacv.cpp.videoInputLib;

public class VideoInputFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    private int deviceNumber = 0;
    private videoInputLib.videoInput myVideoInput = null;
    private opencv_core.IplImage bgrImage = null;
    private opencv_core.IplImage grayImage = null;
    private BytePointer bgrImageData = null;

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        VideoInputFrameGrabber.tryLoad();
        int count = videoInputLib.videoInput.listDevices();
        String[] descriptions = new String[count];
        for (int i2 = 0; i2 < descriptions.length; ++i2) {
            descriptions[i2] = videoInputLib.videoInput.getDeviceName(i2);
        }
        return descriptions;
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(videoInputLib.class);
        }
        catch (Throwable t) {
            loadingException = new FrameGrabber.Exception("Failed to load " + VideoInputFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public VideoInputFrameGrabber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public void release() throws FrameGrabber.Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public int getImageWidth() {
        return this.myVideoInput == null ? super.getImageWidth() : this.myVideoInput.getWidth(this.deviceNumber);
    }

    public int getImageHeight() {
        return this.myVideoInput == null ? super.getImageHeight() : this.myVideoInput.getHeight(this.deviceNumber);
    }

    public void start() throws FrameGrabber.Exception {
        this.start(-1);
    }

    public void start(int connection) throws FrameGrabber.Exception {
        this.myVideoInput = new videoInputLib.videoInput();
        if (this.frameRate > 0.0) {
            this.myVideoInput.setIdealFramerate(this.deviceNumber, (int)this.frameRate);
        }
        if (this.imageWidth <= 0 || this.imageHeight <= 0 ? !this.myVideoInput.setupDevice(this.deviceNumber, connection) : !this.myVideoInput.setupDevice(this.deviceNumber, this.imageWidth, this.imageHeight, connection)) {
            this.myVideoInput = null;
            throw new FrameGrabber.Exception("videoInput.setupDevice() Error: Could not setup device.");
        }
        if (this.format != null && this.format.length() > 0) {
            int f2;
            int n2 = this.format.equals("VI_NTSC_M") ? 0 : (this.format.equals("VI_PAL_B") ? 1 : (this.format.equals("VI_PAL_D") ? 2 : (this.format.equals("VI_PAL_G") ? 3 : (this.format.equals("VI_PAL_H") ? 4 : (this.format.equals("VI_PAL_I") ? 5 : (this.format.equals("VI_PAL_M") ? 6 : (this.format.equals("VI_PAL_N") ? 7 : (this.format.equals("VI_PAL_NC") ? 8 : (this.format.equals("VI_SECAM_B") ? 9 : (this.format.equals("VI_SECAM_D") ? 10 : (this.format.equals("VI_SECAM_G") ? 11 : (this.format.equals("VI_SECAM_H") ? 12 : (this.format.equals("VI_SECAM_K") ? 13 : (this.format.equals("VI_SECAM_K1") ? 14 : (this.format.equals("VI_SECAM_L") ? 15 : (this.format.equals("VI_NTSC_M_J") ? 16 : (f2 = this.format.equals("VI_NTSC_433") ? 17 : -1)))))))))))))))));
            if (f2 >= 0 && !this.myVideoInput.setFormat(this.deviceNumber, f2)) {
                throw new FrameGrabber.Exception("videoInput.setFormat() Error: Could not set format " + this.format + ".");
            }
        }
    }

    public void stop() throws FrameGrabber.Exception {
        if (this.myVideoInput != null) {
            this.myVideoInput.stopDevice(this.deviceNumber);
            this.myVideoInput = null;
        }
    }

    public void trigger() throws FrameGrabber.Exception {
        if (this.myVideoInput == null) {
            throw new FrameGrabber.Exception("videoInput is null. (Has start() been called?)");
        }
        int w = this.myVideoInput.getWidth(this.deviceNumber);
        int h2 = this.myVideoInput.getHeight(this.deviceNumber);
        if (this.bgrImage == null || this.bgrImage.width() != w || this.bgrImage.height() != h2) {
            this.bgrImage = opencv_core.IplImage.create(w, h2, 8, 3);
            this.bgrImageData = this.bgrImage.imageData();
        }
        for (int i2 = 0; i2 < this.numBuffers + 1; ++i2) {
            this.myVideoInput.getPixels(this.deviceNumber, this.bgrImageData, false, true);
        }
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        if (this.myVideoInput == null) {
            throw new FrameGrabber.Exception("videoInput is null. (Has start() been called?)");
        }
        int w = this.myVideoInput.getWidth(this.deviceNumber);
        int h2 = this.myVideoInput.getHeight(this.deviceNumber);
        if (this.bgrImage == null || this.bgrImage.width() != w || this.bgrImage.height() != h2) {
            this.bgrImage = opencv_core.IplImage.create(w, h2, 8, 3);
            this.bgrImageData = this.bgrImage.imageData();
        }
        if (!this.myVideoInput.getPixels(this.deviceNumber, this.bgrImageData, false, true)) {
            throw new FrameGrabber.Exception("videoInput.getPixels() Error: Could not get pixels.");
        }
        this.timestamp = System.nanoTime() / 1000L;
        if (this.imageMode == FrameGrabber.ImageMode.GRAY) {
            if (this.grayImage == null) {
                this.grayImage = opencv_core.IplImage.create(w, h2, 8, 1);
            }
            opencv_imgproc.cvCvtColor(this.bgrImage, this.grayImage, 6);
            return this.grayImage;
        }
        return this.bgrImage;
    }
}

