/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.gsm.GsmEncoder;

public class GsmVadEncoder
extends GsmEncoder {
    private static final float DIST_TH = 0.05f;
    private static final int PITCH_TH = 4;
    private static final int PITCH_PRECISION = 2;
    private static final float PTH = 6.984919E-5f;
    private static final float MARGIN = 0.018626451f;
    private static final float PLEV = 1.8626451E-4f;
    private static final float FAC = 3.0f;
    private static final int ADP = 8;
    private static final float INC = 16.0f;
    private static final float DEC = 32.0f;
    private static final float EPSILON = 1.0E-15f;
    private static final int NEW_SID = -1;
    private static final float MAX_LAR = 1.625f;
    private static final int E_PTH = 19;
    private static final int M_PTH = 18750;
    private static final int E_MARGIN = 27;
    private static final int M_MARGIN = 19531;
    private static final int E_PLEV = 20;
    private static final int M_PLEV = 25000;
    public static final int UPDATE_RATE = 10;
    private static final int nFRAMES = 4;
    int vad_sincelastSID;
    int vad_sinceSPEECHburst;
    float[][] vad_prevLARs = new float[4][8];
    float[][] vad_prevxmax = new float[4][4];
    int[] vad_prevSID = new int[77];
    int vad_hangover;
    int vad_LARindex;
    boolean vad_SP;
    float[] vad_LAR = new float[8];
    float[] vad_currentxmax = new float[4];
    int vad_blocknumber;
    int vad_lastsent;
    boolean vad_prevSP;
    float[] vad_rvad = new float[9];
    float[][] vad_sacf = new float[3][9];
    float[][] vad_sav0 = new float[4][9];
    int vad_sacfPt;
    int vad_sav0Pt;
    float vad_lastdm;
    int vad_oldlagcount;
    int vad_veryoldlagcount;
    int vad_adaptcount;
    int vad_burstcount;
    int vad_hangcount;
    int vad_oldlag;
    float vad_thvad;
    float[] vadAux_av0 = new float[9];
    float[] vadAux_av1 = new float[9];
    float[] vadAux_refcoef = new float[9];
    float[] vadAux_rav1 = new float[9];
    float[] vadAux_coef = new float[9];
    float[] vadAux_tempcoef = new float[9];
    float[] vadAux_aav1 = new float[9];

    protected void doVAD() {
        this.vad_calculations();
        this.DisConTrans();
    }

    public void gsm_encoder_reset() {
        super.gsm_encoder_reset();
        this.vadSupportFlag = true;
        this.vad_sincelastSID = 24;
        this.vad_sinceSPEECHburst = 0;
        int i2 = 0;
        while (i2 < this.vad_prevLARs.length) {
            int j2 = 0;
            while (j2 < this.vad_prevLARs[i2].length) {
                this.vad_prevLARs[i2][j2] = 0.0f;
                ++j2;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.vad_prevxmax.length) {
            this.vad_prevxmax[i3][0] = 0.0f;
            this.vad_prevxmax[i3][1] = 0.0f;
            this.vad_prevxmax[i3][2] = 0.0f;
            this.vad_prevxmax[i3][3] = 0.0f;
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.vad_prevSID.length) {
            this.vad_prevSID[i4] = 0;
            ++i4;
        }
        this.vad_prevSID[0] = 2;
        this.vad_prevSID[1] = 28;
        this.vad_prevSID[2] = 18;
        this.vad_prevSID[3] = 12;
        this.vad_prevSID[4] = 7;
        this.vad_prevSID[5] = 5;
        this.vad_prevSID[6] = 3;
        this.vad_prevSID[7] = 2;
        this.vad_hangover = 1;
        this.vad_LARindex = 0;
        this.vad_SP = true;
        this.vad_prevSP = true;
        this.vad_lastsent = 0;
        this.vad_rvad[0] = 6.0f;
        this.vad_rvad[1] = -4.0f;
        this.vad_rvad[2] = 1.0f;
        int i5 = 3;
        while (i5 < this.vad_rvad.length) {
            this.vad_rvad[i5] = 0.0f;
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.vad_sacf.length) {
            int j3 = 0;
            while (j3 < this.vad_sacf[i6].length) {
                this.vad_sacf[i6][j3] = 0.0f;
                ++j3;
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < this.vad_sav0.length) {
            int j4 = 0;
            while (j4 < this.vad_sav0[i7].length) {
                this.vad_sav0[i7][j4] = 0.0f;
                ++j4;
            }
            ++i7;
        }
        this.vad_sacfPt = 0;
        this.vad_sav0Pt = 0;
        this.vad_lastdm = 0.0f;
        this.vad_oldlagcount = 0;
        this.vad_veryoldlagcount = 0;
        this.vad_adaptcount = 0;
        this.vad_burstcount = 0;
        this.vad_hangcount = -1;
        this.vad_oldlag = 40;
        this.vad_thvad = 2.3283064E-4f;
    }

    void vad_calculations() {
        int[] lg2s = GsmEncoder.lut_lg2s;
        boolean vadF = this.VAD(this.data_acf, this.data_Nc);
        if (vadF) {
            this.vad_sinceSPEECHburst = 0;
            this.vad_SP = true;
            this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
            int i2 = 0;
            while (i2 < 8) {
                this.vad_prevLARs[this.vad_LARindex][i2] = this.vad_LAR[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                this.vad_prevxmax[this.vad_LARindex][i2] = this.vad_currentxmax[i2];
                ++i2;
            }
            if (this.vad_sincelastSID < 24) {
                ++this.vad_sincelastSID;
            }
        } else {
            if (this.vad_sinceSPEECHburst++ == 0) {
                this.vad_hangover = this.vad_sincelastSID >= 24 ? 1 : 0;
            } else if (this.vad_sinceSPEECHburst > 4) {
                this.vad_hangover = -1;
            }
            if (this.vad_hangover == 1) {
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                int i2 = 0;
                while (i2 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][i2] = this.data_LAR[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][i2] = this.vad_currentxmax[i2];
                    ++i2;
                }
                if (this.vad_sincelastSID < 24) {
                    ++this.vad_sincelastSID;
                }
                this.vad_SP = true;
            } else if (this.vad_hangover == 0) {
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                int i2 = 0;
                while (i2 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][i2] = this.data_LAR[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][i2] = this.vad_currentxmax[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < 77) {
                    this.data_Parameters[i2] = this.vad_prevSID[i2];
                    ++i2;
                }
                if (this.vad_sincelastSID < 24) {
                    ++this.vad_sincelastSID;
                }
                this.vad_SP = false;
            } else {
                int i2 = 1;
                while (i2 <= 8) {
                    float LARinter = 0.25f * (this.vad_prevLARs[0][i2 - 1] + this.vad_prevLARs[1][i2 - 1] + this.vad_prevLARs[2][i2 - 1] + this.vad_prevLARs[3][i2 - 1]);
                    if ((LARinter = GsmEncoder.lut_A[i2] * LARinter + GsmEncoder.lut_B[i2]) > GsmEncoder.lut_MAC[i2]) {
                        LARinter = GsmEncoder.lut_MAC[i2];
                    }
                    if (LARinter < GsmEncoder.lut_MIC[i2]) {
                        LARinter = GsmEncoder.lut_MIC[i2];
                    }
                    this.vad_prevSID[i2 - 1] = (int)(LARinter - GsmEncoder.lut_MIC[i2] + 0.5f);
                    ++i2;
                }
                float XMAXinter = 0.0f;
                i2 = 0;
                while (i2 < 4) {
                    int k2 = 0;
                    while (k2 < 4) {
                        XMAXinter += this.vad_prevxmax[k2][i2];
                        ++k2;
                    }
                    ++i2;
                }
                if ((double)(XMAXinter *= 0.0625f) < 0.015625) {
                    XMAXinter *= 1024.0f;
                } else {
                    int temp = (int)(32768.0 * (double)XMAXinter);
                    if ((temp >>= 10) < 31) {
                        i2 = lg2s[temp];
                        XMAXinter = (float)(i2 << 3) + XMAXinter * (float)(1024 >> i2);
                    } else {
                        XMAXinter = 63.0f;
                    }
                }
                i2 = 0;
                while (i2 < 4) {
                    this.vad_prevSID[11 + 17 * i2] = (int)XMAXinter;
                    ++i2;
                }
                this.vad_LARindex = this.vad_LARindex == 3 ? 0 : this.vad_LARindex + 1;
                i2 = 0;
                while (i2 < 8) {
                    this.vad_prevLARs[this.vad_LARindex][i2] = this.data_LAR[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < 4) {
                    this.vad_prevxmax[this.vad_LARindex][i2] = this.vad_currentxmax[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < 77) {
                    this.data_Parameters[i2] = this.vad_prevSID[i2];
                    ++i2;
                }
                this.vad_sincelastSID = 0;
                this.vad_SP = false;
            }
        }
    }

    void DisConTrans() {
        boolean sendF = false;
        if (this.vad_SP) {
            this.frameType = 0;
            sendF = true;
        } else if (!this.vad_SP && this.vad_prevSP) {
            this.frameType = 1;
            sendF = true;
        }
        this.vad_prevSP = this.vad_SP;
        if (sendF) {
            this.vad_lastsent = 0;
        } else if (this.sidUpdateRate > 0 && ++this.vad_lastsent >= this.sidUpdateRate) {
            this.vad_lastsent = 0;
            sendF = true;
            this.frameType = 1;
        } else {
            int i2 = 0;
            while (i2 < 77) {
                this.data_Parameters[i2] = 0;
                ++i2;
            }
            this.frameType = 2;
        }
    }

    boolean VAD(float[] ACF, int[] Nc) {
        float[] av0 = this.vadAux_av0;
        float[] av1 = this.vadAux_av1;
        float[] refcoef = this.vadAux_refcoef;
        float[] rav1 = this.vadAux_rav1;
        float pvad = this.adaptiveFiltering(ACF);
        this.ACFaverage(ACF, av0, av1);
        this.schurRecursion(av1, refcoef);
        this.Step_up(refcoef, rav1);
        boolean statF = this.SpectralComp(rav1, av0);
        boolean pitchF = this.PitchDetect();
        this.ThresAdapt(pitchF, statF, ACF, rav1, pvad);
        boolean vadF = this.vad_decision(pvad);
        this.pitchCounting(Nc);
        return vadF;
    }

    float adaptiveFiltering(float[] ACF) {
        if (ACF[0] < 1.0E-15f) {
            float pvad = 0.0f;
            ACF[0] = 0.0f;
            return pvad;
        }
        float pvad = 0.0f;
        int i2 = 1;
        while (i2 <= 8) {
            pvad += this.vad_rvad[i2] * ACF[i2];
            ++i2;
        }
        pvad = 2.0f * pvad + this.vad_rvad[0] * ACF[0];
        return pvad;
    }

    void ACFaverage(float[] ACF, float[] av0, float[] av1) {
        int sacfPt = this.vad_sacfPt;
        int sav0Pt = this.vad_sav0Pt;
        int i2 = 0;
        while (i2 <= 8) {
            av0[i2] = ACF[i2] + this.vad_sacf[0][i2] + this.vad_sacf[1][i2] + this.vad_sacf[2][i2];
            this.vad_sacf[sacfPt][i2] = ACF[i2];
            av1[i2] = this.vad_sav0[sav0Pt][i2];
            this.vad_sav0[sav0Pt][i2] = av0[i2];
            ++i2;
        }
        this.vad_sacfPt = sacfPt == 2 ? 0 : sacfPt + 1;
        this.vad_sav0Pt = sav0Pt == 3 ? 0 : sav0Pt + 1;
    }

    void Step_up(float[] refcoef, float[] rav1) {
        int i2;
        float[] coef = this.vadAux_coef;
        float[] tempcoef = this.vadAux_tempcoef;
        float[] aav1 = this.vadAux_aav1;
        coef[0] = 1.0f;
        coef[1] = refcoef[1];
        int m3 = 2;
        while (m3 < 9) {
            i2 = 1;
            while (i2 < m3) {
                tempcoef[i2] = coef[i2] + refcoef[m3] * coef[m3 - i2];
                ++i2;
            }
            i2 = 1;
            while (i2 < m3) {
                coef[i2] = tempcoef[i2];
                ++i2;
            }
            coef[m3] = refcoef[m3];
            ++m3;
        }
        i2 = 0;
        while (i2 <= 8) {
            aav1[i2] = coef[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 <= 8) {
            rav1[i2] = 0.0f;
            int k2 = 0;
            while (k2 <= 8 - i2) {
                rav1[i2] = rav1[i2] + aav1[k2] * aav1[k2 + i2];
                ++k2;
            }
            ++i2;
        }
    }

    boolean SpectralComp(float[] rav1, float[] av0) {
        float distortion;
        if (av0[0] < 1.0E-15f) {
            distortion = 0.0f;
            int i2 = 1;
            while (i2 <= 8) {
                distortion += rav1[i2];
                ++i2;
            }
            distortion = 2.0f * distortion + rav1[0];
        } else {
            distortion = 0.0f;
            int i2 = 1;
            while (i2 <= 8) {
                distortion += rav1[i2] * av0[i2];
                ++i2;
            }
            distortion = 2.0f * distortion + rav1[0] * av0[0];
            distortion /= av0[0];
        }
        float difference = distortion - this.vad_lastdm;
        boolean statF = difference < 0.05f && difference > -0.05f;
        this.vad_lastdm = distortion;
        return statF;
    }

    boolean PitchDetect() {
        return this.vad_oldlagcount + this.vad_veryoldlagcount >= 4;
    }

    void ThresAdapt(boolean pitchF, boolean statF, float[] ACF, float[] rav1, float pvad) {
        float thvad = this.vad_thvad;
        if (ACF[0] < 6.984919E-5f) {
            this.vad_thvad = 1.8626451E-4f;
            return;
        }
        if (pitchF || !statF) {
            this.vad_adaptcount = 0;
            return;
        }
        if (++this.vad_adaptcount <= 8) {
            return;
        }
        float temp = pvad * 3.0f;
        if ((thvad -= thvad / 32.0f) < temp && temp < (thvad += thvad / 16.0f)) {
            thvad = temp;
        }
        if (thvad > (temp = pvad + 0.018626451f)) {
            thvad = temp;
        }
        this.vad_thvad = thvad;
        int i2 = 0;
        while (i2 <= 8) {
            this.vad_rvad[i2] = rav1[i2];
            ++i2;
        }
        this.vad_adaptcount = 9;
    }

    boolean vad_decision(float pvad) {
        boolean vadF;
        if (pvad > this.vad_thvad) {
            vadF = true;
            ++this.vad_burstcount;
            if (this.vad_burstcount >= 3) {
                this.vad_hangcount = 5;
                this.vad_burstcount = 3;
            }
        } else {
            vadF = false;
            this.vad_burstcount = 0;
        }
        if (this.vad_hangcount >= 0) {
            vadF = true;
            --this.vad_hangcount;
        }
        return vadF;
    }

    void pitchCounting(int[] Nc) {
        int lagcount = 0;
        int i2 = 0;
        while (i2 <= 3) {
            int maxlag;
            int minlag;
            if (this.vad_oldlag > Nc[i2]) {
                minlag = Nc[i2];
                maxlag = this.vad_oldlag;
            } else {
                minlag = this.vad_oldlag;
                maxlag = Nc[i2];
            }
            int smallag = maxlag % minlag;
            if (smallag < 2 || minlag - smallag < 2) {
                ++lagcount;
            }
            this.vad_oldlag = Nc[i2];
            ++i2;
        }
        this.vad_veryoldlagcount = this.vad_oldlagcount;
        this.vad_oldlagcount = lagcount;
    }
}

