/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class AviVideoFormat
extends VideoFormat {
    protected int planes = -1;
    protected int bitsPerPixel = -1;
    protected int imageSize = -1;
    protected int xPelsPerMeter = -1;
    protected int yPelsPerMeter = -1;
    protected int clrUsed = -1;
    protected int clrImportant = -1;
    protected byte[] codecSpecificHeader = null;

    public AviVideoFormat(String encoding) {
        super(encoding);
    }

    public AviVideoFormat(String encoding, Dimension size, int maxDataLength, Class dataType, float frameRate, int planes, int bitsPerPixel, int imageSize, int xPelsPerMeter, int yPelsPerMeter, int clrUsed, int clrImportant, byte[] codecHeader) {
        super(encoding, size, maxDataLength, dataType, frameRate);
        this.planes = planes;
        this.bitsPerPixel = bitsPerPixel;
        this.imageSize = imageSize;
        this.xPelsPerMeter = xPelsPerMeter;
        this.yPelsPerMeter = yPelsPerMeter;
        this.clrUsed = clrUsed;
        this.clrImportant = clrImportant;
        this.codecSpecificHeader = codecHeader;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public int getXPelsPerMeter() {
        return this.xPelsPerMeter;
    }

    public int getYPelsPerMeter() {
        return this.yPelsPerMeter;
    }

    public int getClrUsed() {
        return this.clrUsed;
    }

    public int getClrImportant() {
        return this.clrImportant;
    }

    public byte[] getCodecSpecificHeader() {
        return this.codecSpecificHeader;
    }

    public Object clone() {
        AviVideoFormat f2 = new AviVideoFormat(this.encoding);
        f2.copy(this);
        return f2;
    }

    protected void copy(Format f2) {
        super.copy(f2);
        if (f2 instanceof AviVideoFormat) {
            AviVideoFormat other = (AviVideoFormat)f2;
            this.planes = other.planes;
            this.bitsPerPixel = other.bitsPerPixel;
            this.imageSize = other.imageSize;
            this.xPelsPerMeter = other.xPelsPerMeter;
            this.yPelsPerMeter = other.yPelsPerMeter;
            this.clrUsed = other.clrUsed;
            this.clrImportant = other.clrImportant;
            this.codecSpecificHeader = other.codecSpecificHeader;
        }
    }

    public boolean equals(Object format) {
        if (format instanceof AviVideoFormat) {
            boolean result;
            AviVideoFormat other = (AviVideoFormat)format;
            boolean bl = result = super.equals(format) && this.planes == other.planes && this.bitsPerPixel == other.bitsPerPixel && this.imageSize == other.imageSize && this.xPelsPerMeter == other.xPelsPerMeter && this.yPelsPerMeter == other.yPelsPerMeter && this.clrUsed == other.clrUsed && this.clrImportant == other.clrImportant;
            if (!result) {
                return false;
            }
            if (this.codecSpecificHeader == other.codecSpecificHeader) {
                return true;
            }
            if (this.codecSpecificHeader == null || other.codecSpecificHeader == null) {
                return false;
            }
            if (this.codecSpecificHeader.length != other.codecSpecificHeader.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.codecSpecificHeader.length) {
                if (this.codecSpecificHeader[i2] != other.codecSpecificHeader[i2]) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AviVideoFormat)) {
            return true;
        }
        AviVideoFormat other = (AviVideoFormat)format;
        boolean returnVal = !(this.planes != -1 && other.planes != -1 && this.planes != other.planes || this.bitsPerPixel != -1 && other.bitsPerPixel != -1 && this.bitsPerPixel != other.bitsPerPixel || this.imageSize != -1 && other.imageSize != -1 && this.imageSize != other.imageSize || this.xPelsPerMeter != -1 && other.xPelsPerMeter != -1 && this.xPelsPerMeter != other.xPelsPerMeter || this.yPelsPerMeter != -1 && other.yPelsPerMeter != -1 && this.yPelsPerMeter != other.yPelsPerMeter || this.clrUsed != -1 && other.clrUsed != -1 && this.clrUsed != other.clrUsed || this.clrImportant != -1 && other.clrImportant != -1 && this.clrImportant != other.clrImportant || this.codecSpecificHeader != null && other.codecSpecificHeader != null && this.codecSpecificHeader != other.codecSpecificHeader && !this.codecSpecificHeader.equals(this.codecSpecificHeader));
        return returnVal;
    }

    public Format intersects(Format format) {
        Format fmt = super.intersects(format);
        if (fmt == null) {
            return null;
        }
        if (!(format instanceof AviVideoFormat)) {
            return fmt;
        }
        AviVideoFormat other = (AviVideoFormat)format;
        AviVideoFormat res = (AviVideoFormat)fmt;
        res.planes = this.planes != -1 ? this.planes : other.planes;
        res.bitsPerPixel = this.bitsPerPixel != -1 ? this.bitsPerPixel : other.bitsPerPixel;
        res.imageSize = this.imageSize != -1 ? this.imageSize : other.imageSize;
        res.xPelsPerMeter = this.xPelsPerMeter != -1 ? this.xPelsPerMeter : other.xPelsPerMeter;
        res.yPelsPerMeter = this.yPelsPerMeter != -1 ? this.yPelsPerMeter : other.yPelsPerMeter;
        res.clrUsed = this.clrUsed != -1 ? this.clrUsed : other.clrUsed;
        res.clrImportant = this.clrImportant != -1 ? this.clrImportant : other.clrImportant;
        res.codecSpecificHeader = this.codecSpecificHeader != null ? this.codecSpecificHeader : other.codecSpecificHeader;
        return res;
    }

    public Format relax() {
        AviVideoFormat fmt = (AviVideoFormat)super.relax();
        if (fmt == null) {
            return null;
        }
        fmt.imageSize = -1;
        return fmt;
    }

    public String toString() {
        String s2 = super.toString() + " " + (this.codecSpecificHeader != null ? this.codecSpecificHeader.length : 0) + " extra bytes";
        return s2;
    }
}

