/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.sun.media.renderer.audio.device.SunAudioOutput;
import com.sun.media.util.LoopThread;

class SunAudioPlayThread
extends LoopThread {
    long initialTime;
    long currentTime;
    int samplesUpdated;
    int sunAudioInternalDelay = -1;
    SunAudioOutput sunAudioOutput;

    SunAudioPlayThread() {
        this.setName(this.getName() + ": " + this);
    }

    void setStream(SunAudioOutput s2) {
        this.sunAudioOutput = s2;
    }

    public void resetSampleCountTime() {
        this.initialTime = System.currentTimeMillis();
    }

    public synchronized void start() {
        this.currentTime = System.currentTimeMillis();
        super.start();
    }

    public void setInternalDelay(int delay) {
        if (delay >= 0) {
            this.sunAudioInternalDelay = delay;
        }
        this.sunAudioOutput.setPaddingLength(this.sunAudioInternalDelay * 2);
    }

    protected boolean process() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        if (this.sunAudioInternalDelay >= 0) {
            int tmpSamplesPlayed;
            this.currentTime = System.currentTimeMillis();
            this.samplesUpdated = (int)((this.currentTime - this.initialTime) * 8L);
            if (this.samplesUpdated >= 0 && !this.sunAudioOutput.paused && (tmpSamplesPlayed = this.sunAudioOutput.sunAudioInitialCount + this.samplesUpdated) > this.sunAudioOutput.samplesPlayed && tmpSamplesPlayed <= this.sunAudioOutput.sunAudioFinalCount && tmpSamplesPlayed - this.sunAudioInternalDelay > this.sunAudioOutput.samplesPlayed) {
                this.sunAudioOutput.samplesPlayed = tmpSamplesPlayed - this.sunAudioInternalDelay;
            }
        }
        return true;
    }
}

