/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.api.DefaultTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.SikuliRuntimeException;
import org.sikuli.api.Target;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.algorithm.TemplateMatcher;

public class ImageTarget
extends DefaultTarget
implements Target {
    final BufferedImage targetImage;
    private final String imageSource;
    private URL url = null;

    public ImageTarget(URL url) {
        try {
            this.targetImage = ImageIO.read(url);
        }
        catch (IOException e2) {
            throw new SikuliRuntimeException("Image file can not be loaded from " + url + " because " + e2.getMessage());
        }
        this.imageSource = url.toString();
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public ImageTarget(File file) {
        try {
            this.targetImage = ImageIO.read(file);
        }
        catch (IOException e2) {
            throw new RuntimeException("Image file can not be loaded from " + file);
        }
        this.imageSource = file.getAbsolutePath();
    }

    public ImageTarget(BufferedImage targetImage) {
        this.targetImage = targetImage;
        this.imageSource = "[BufferedImage]";
    }

    public String toString() {
        return "[ImageTarget: " + this.imageSource + "]";
    }

    public BufferedImage getImage() {
        return this.targetImage;
    }

    @Override
    public BufferedImage toImage() {
        return this.targetImage;
    }

    @Override
    protected double getDefaultMinScore() {
        return 0.7;
    }

    @Override
    protected List<ScreenRegion> getUnordredMatches(ScreenRegion screenRegion) {
        Rectangle screenRegionBounds = screenRegion.getBounds();
        if (screenRegionBounds.width < this.targetImage.getWidth() || screenRegionBounds.height < this.targetImage.getHeight()) {
            return Lists.newArrayList();
        }
        List<Rectangle> rois = screenRegion.getROIs();
        List<RegionMatch> matches = rois.isEmpty() ? TemplateMatcher.findMatchesByGrayscaleAtOriginalResolution(screenRegion.capture(), this.targetImage, this.getLimit(), this.getMinScore()) : TemplateMatcher.findMatchesByGrayscaleAtOriginalResolutionWithROIs(screenRegion.capture(), this.targetImage, this.getLimit(), this.getMinScore(), rois);
        return ImageTarget.convertToScreenRegions(screenRegion, matches);
    }
}

