/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.event;

import org.sikuli.api.Relative;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.event.EventDetectionTask;
import org.sikuli.api.event.TargetEvent;
import org.sikuli.api.event.TargetEventListener;

class TargetEventDetectionTask
implements EventDetectionTask {
    private final ScreenRegion screenRegion;
    private final Target target;
    private final TargetEventListener listener;
    private ScreenRegion lastTargetRegion;

    public boolean equals(Object o2) {
        TargetEventDetectionTask w = (TargetEventDetectionTask)o2;
        return this.screenRegion == w.screenRegion && this.target == w.target && this.listener == w.listener;
    }

    public TargetEventDetectionTask(ScreenRegion screenRegion, Target target, TargetEventListener listener) {
        this.screenRegion = screenRegion;
        this.target = target;
        this.listener = listener;
        this.lastTargetRegion = null;
    }

    public void setLastTargetRegion(ScreenRegion lastTargetRegion) {
        this.lastTargetRegion = lastTargetRegion;
    }

    public TargetEvent createTargetEvent() {
        return new TargetEvent(this.target, this.screenRegion, this.lastTargetRegion);
    }

    @Override
    public void run() {
        ScreenRegion currentTargetRegion = null;
        if (this.lastTargetRegion == null) {
            currentTargetRegion = this.screenRegion.find(this.target);
            if (currentTargetRegion != null) {
                this.setLastTargetRegion(currentTargetRegion);
                this.listener.targetAppeared(this.createTargetEvent());
            }
        } else if (!this.isTargetStillAtTheLastLocation()) {
            currentTargetRegion = this.screenRegion.find(this.target);
            if (currentTargetRegion == null) {
                this.listener.targetVanished(this.createTargetEvent());
                this.setLastTargetRegion(null);
            } else {
                this.setLastTargetRegion(currentTargetRegion);
                this.listener.targetMoved(this.createTargetEvent());
            }
        }
    }

    private boolean isTargetStillAtTheLastLocation() {
        if (this.lastTargetRegion == null) {
            return false;
        }
        ScreenRegion r = this.screenRegion.find(this.target);
        if (r == null) {
            return false;
        }
        ScreenLocation newLocation = Relative.to(r).topLeft().getScreenLocation();
        ScreenLocation lastLocation = Relative.to(this.lastTargetRegion).topLeft().getScreenLocation();
        boolean isXClose = Math.abs(newLocation.getX() - lastLocation.getX()) < 3;
        boolean isYClose = Math.abs(newLocation.getY() - lastLocation.getY()) < 3;
        return isXClose && isYClose;
    }
}

