/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot;

import java.awt.Toolkit;
import org.sikuli.api.robot.OS;

public class Env {
    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static OS getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x")) {
            return OS.MAC;
        }
        if (os.startsWith("windows")) {
            return OS.WINDOWS;
        }
        if (os.startsWith("linux")) {
            return OS.LINUX;
        }
        return OS.NOT_SUPPORTED;
    }

    public static boolean isWindows() {
        return Env.getOS() == OS.WINDOWS;
    }

    public static boolean isLinux() {
        return Env.getOS() == OS.LINUX;
    }

    public static boolean isMac() {
        return Env.getOS() == OS.MAC;
    }

    public static String getSeparator() {
        if (Env.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static boolean isLockOn(char key) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        switch (key) {
            case '\ue025': {
                return tk.getLockingKeyState(145);
            }
            case '\ue027': {
                return tk.getLockingKeyState(20);
            }
            case '\ue03b': {
                return tk.getLockingKeyState(144);
            }
        }
        return false;
    }

    public static int getHotkeyModifier() {
        if (Env.getOS() == OS.MAC) {
            return 157;
        }
        return 17;
    }
}

