/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import org.sikuli.core.cv.FindResult;

class MatchFetcher {
    opencv_core.IplImage resultMatrix;
    opencv_core.IplImage target;

    MatchFetcher(opencv_core.IplImage resultMatrix, opencv_core.IplImage target) {
        this.resultMatrix = resultMatrix;
        this.target = target;
    }

    FindResult fetchNextMatch() {
        double[] min2 = new double[1];
        double[] max = new double[1];
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)this.resultMatrix, min2, max, minPoint, maxPoint, null);
        double detectionScore = max[0];
        opencv_core.CvPoint detectionLoc = maxPoint;
        FindResult r = new FindResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = this.target.width();
        r.height = this.target.height();
        r.score = detectionScore;
        int xmargin = this.target.width() / 3;
        int ymargin = this.target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, this.resultMatrix.width());
        int y1 = Math.min(y + ymargin, this.resultMatrix.height());
        opencv_core.cvRectangle(this.resultMatrix, opencv_core.cvPoint(x0, y0), opencv_core.cvPoint(x1 - 1, y1 - 1), opencv_core.cvRealScalar(0.0), -1, 8, 0);
        return r;
    }
}

